/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.connection;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.connection.ConnectionHandlingPolicy;
import org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardConnectionHandlingPolicy
implements ConnectionHandlingPolicy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final int expirationPercent;

    public StandardConnectionHandlingPolicy() {
        this(100);
    }

    public StandardConnectionHandlingPolicy(int expirationPercent) {
        Preconditions.checkArgument((expirationPercent > 0 && expirationPercent <= 100 ? 1 : 0) != 0, (Object)"expirationPercent must be > 0 and <= 100");
        this.expirationPercent = expirationPercent;
    }

    @Override
    public int getSimulatedSessionExpirationPercent() {
        return this.expirationPercent;
    }

    @Override
    public <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        client.internalBlockUntilConnectedOrTimedOut();
        T result = null;
        RetryLoop retryLoop = client.newRetryLoop();
        while (retryLoop.shouldContinue()) {
            try {
                result = proc.call();
                retryLoop.markComplete();
            }
            catch (Exception e) {
                ThreadUtils.checkInterrupted(e);
                retryLoop.takeException(e);
            }
        }
        return result;
    }

    @Override
    public ConnectionHandlingPolicy.CheckTimeoutsResult checkTimeouts(Callable<String> hasNewConnectionString, long connectionStartMs, int sessionTimeoutMs, int connectionTimeoutMs) throws Exception {
        if (hasNewConnectionString.call() != null) {
            return ConnectionHandlingPolicy.CheckTimeoutsResult.NEW_CONNECTION_STRING;
        }
        return ConnectionHandlingPolicy.CheckTimeoutsResult.NOP;
    }
}

