/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.connection;

import java.util.concurrent.Callable;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryLoop;
import org.apache.curator.connection.ConnectionHandlingPolicy;

public class ClassicConnectionHandlingPolicy
implements ConnectionHandlingPolicy {
    @Override
    public int getSimulatedSessionExpirationPercent() {
        return 0;
    }

    @Override
    public <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        T result = null;
        RetryLoop retryLoop = client.newRetryLoop();
        while (retryLoop.shouldContinue()) {
            try {
                client.internalBlockUntilConnectedOrTimedOut();
                result = proc.call();
                retryLoop.markComplete();
            }
            catch (Exception e) {
                retryLoop.takeException(e);
            }
        }
        return result;
    }

    @Override
    public ConnectionHandlingPolicy.CheckTimeoutsResult checkTimeouts(Callable<String> hasNewConnectionString, long connectionStartMs, int sessionTimeoutMs, int connectionTimeoutMs) throws Exception {
        ConnectionHandlingPolicy.CheckTimeoutsResult result = ConnectionHandlingPolicy.CheckTimeoutsResult.NOP;
        int minTimeout = Math.min(sessionTimeoutMs, connectionTimeoutMs);
        long elapsed = System.currentTimeMillis() - connectionStartMs;
        if (elapsed >= (long)minTimeout) {
            int maxTimeout;
            result = hasNewConnectionString.call() != null ? ConnectionHandlingPolicy.CheckTimeoutsResult.NEW_CONNECTION_STRING : (elapsed > (long)(maxTimeout = Math.max(sessionTimeoutMs, connectionTimeoutMs)) ? ConnectionHandlingPolicy.CheckTimeoutsResult.RESET_CONNECTION : ConnectionHandlingPolicy.CheckTimeoutsResult.CONNECTION_TIMEOUT);
        }
        return result;
    }
}

