/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.webdav4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.vfs2.FileContentInfoFactory;
import org.apache.commons.vfs2.FileNotFolderException;
import org.apache.commons.vfs2.FileNotFoundException;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.DefaultFileContent;
import org.apache.commons.vfs2.provider.GenericURLFileName;
import org.apache.commons.vfs2.provider.http4.Http4FileObject;
import org.apache.commons.vfs2.provider.http4.Http4FileSystem;
import org.apache.commons.vfs2.provider.http4.Http4FileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav4.ExceptionConverter;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileContentInfoFactory;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystem;
import org.apache.commons.vfs2.provider.webdav4.Webdav4FileSystemConfigBuilder;
import org.apache.commons.vfs2.util.FileObjectUtils;
import org.apache.commons.vfs2.util.MonitorOutputStream;
import org.apache.commons.vfs2.util.URIUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.BaseDavRequest;
import org.apache.jackrabbit.webdav.client.methods.HttpCheckin;
import org.apache.jackrabbit.webdav.client.methods.HttpCheckout;
import org.apache.jackrabbit.webdav.client.methods.HttpDelete;
import org.apache.jackrabbit.webdav.client.methods.HttpMkcol;
import org.apache.jackrabbit.webdav.client.methods.HttpMove;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.client.methods.HttpProppatch;
import org.apache.jackrabbit.webdav.client.methods.HttpVersionControl;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyIterator;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Node;

public class Webdav4FileObject
extends Http4FileObject<Webdav4FileSystem> {
    private static final Webdav4FileObject[] EMPTY_ARRAY = new Webdav4FileObject[0];
    public static final DavPropertyName RESPONSE_CHARSET = DavPropertyName.create((String)"response-charset");
    private final Webdav4FileSystemConfigBuilder builder;

    protected Webdav4FileObject(AbstractFileName name, Webdav4FileSystem fileSystem) throws FileSystemException {
        this(name, fileSystem, Webdav4FileSystemConfigBuilder.getInstance());
    }

    void log(Exception ex) {
    }

    protected Webdav4FileObject(AbstractFileName name, Webdav4FileSystem fileSystem, Webdav4FileSystemConfigBuilder builder) throws FileSystemException {
        super(name, (Http4FileSystem)fileSystem, (Http4FileSystemConfigBuilder)builder);
        this.builder = builder;
    }

    protected void doCreateFolder() throws Exception {
        HttpMkcol request = new HttpMkcol(this.toUrlString((GenericURLFileName)this.getName()));
        this.setupRequest((HttpUriRequest)request);
        try {
            this.executeRequest((HttpUriRequest)request);
        }
        catch (FileSystemException fse) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", (Object)this.getName(), (Throwable)fse);
        }
    }

    protected void doDelete() throws Exception {
        HttpDelete request = new HttpDelete(this.toUrlString((GenericURLFileName)this.getName()));
        this.setupRequest((HttpUriRequest)request);
        this.executeRequest((HttpUriRequest)request);
    }

    protected Map<String, Object> doGetAttributes() throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        try {
            GenericURLFileName fileName = (GenericURLFileName)this.getName();
            DavPropertySet properties = this.getProperties(fileName, 1, new DavPropertyNameSet(), false);
            DavPropertyIterator iter = properties.iterator();
            while (iter.hasNext()) {
                DavProperty property = iter.nextProperty();
                attributes.put(property.getName().toString(), property.getValue());
            }
            properties = this.getPropertyNames(fileName);
            DavPropertyIterator iter2 = properties.iterator();
            while (iter2.hasNext()) {
                DavProperty<?> property = iter2.nextProperty();
                if (attributes.containsKey(property.getName().getName()) || (property = this.getProperty(fileName, property.getName())) == null) continue;
                DavPropertyName name = property.getName();
                Object value = property.getValue();
                if (name == null || value == null) continue;
                attributes.put(name.toString(), value);
            }
            return attributes;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.webdav/get-attributes.error", (Object)this.getName(), (Throwable)e);
        }
    }

    protected long doGetContentSize() throws Exception {
        DavProperty<?> property = this.getProperty((GenericURLFileName)this.getName(), "getcontentlength");
        if (property != null) {
            String value = (String)property.getValue();
            return Long.parseLong(value);
        }
        return 0L;
    }

    protected long doGetLastModifiedTime() throws Exception {
        DavProperty<?> property = this.getProperty((GenericURLFileName)this.getName(), "getlastmodified");
        if (property != null) {
            String value = (String)property.getValue();
            return DateUtils.parseDate((String)value).getTime();
        }
        return 0L;
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws Exception {
        return new WebdavOutputStream(this);
    }

    protected FileType doGetType() throws Exception {
        try {
            return this.isDirectory((GenericURLFileName)this.getName()) ? FileType.FOLDER : FileType.FILE;
        }
        catch (FileNotFolderException | FileNotFoundException fnfe) {
            return FileType.IMAGINARY;
        }
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        HttpPropfind request = null;
        try {
            GenericURLFileName name = (GenericURLFileName)this.getName();
            if (this.isDirectory(name)) {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DavPropertyName.create((String)"displayname"));
                request = new HttpPropfind(this.toUrlString(name), nameSet, 1);
                HttpResponse res = this.executeRequest((HttpUriRequest)request);
                ArrayList<Webdav4FileObject> vfs = new ArrayList<Webdav4FileObject>();
                if (request.succeeded(res)) {
                    MultiStatusResponse[] responses;
                    for (MultiStatusResponse response : responses = request.getResponseBodyAsMultiStatus(res).getResponses()) {
                        String resourceName;
                        if (this.isCurrentFile(response.getHref(), name) || (resourceName = this.resourceName(response.getHref())) == null || resourceName.isEmpty()) continue;
                        Webdav4FileObject fo = (Webdav4FileObject)FileObjectUtils.getAbstractFileObject((FileObject)this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), resourceName, NameScope.CHILD)));
                        vfs.add(fo);
                    }
                }
                FileObject[] fileObjectArray = (FileObject[])vfs.toArray(EMPTY_ARRAY);
                return fileObjectArray;
            }
            try {
                throw new FileNotFolderException((Object)this.getName());
            }
            catch (FileNotFolderException fnfe) {
                throw fnfe;
            }
            catch (IOException | DavException e) {
                throw new FileSystemException(e.getMessage(), e);
            }
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    protected void doRename(FileObject newFile) throws Exception {
        String url = URIUtils.encodePath((String)this.toUrlString((GenericURLFileName)this.getName()));
        String dest = this.toUrlString((GenericURLFileName)newFile.getName(), false);
        HttpMove request = new HttpMove(url, dest, false);
        this.setupRequest((HttpUriRequest)request);
        this.executeRequest((HttpUriRequest)request);
    }

    protected void doSetAttribute(String attrName, Object value) throws Exception {
        try {
            GenericURLFileName fileName = (GenericURLFileName)this.getName();
            String urlStr = this.toUrlString(fileName);
            DavPropertySet properties = new DavPropertySet();
            DavPropertyNameSet propertyNameSet = new DavPropertyNameSet();
            DefaultDavProperty property = new DefaultDavProperty(attrName, value, Namespace.EMPTY_NAMESPACE);
            if (value != null) {
                properties.add((DavProperty)property);
            } else {
                propertyNameSet.add(property.getName());
            }
            HttpProppatch request = new HttpProppatch(urlStr, properties, propertyNameSet);
            this.setupRequest((HttpUriRequest)request);
            HttpResponse response = this.executeRequest((HttpUriRequest)request);
            if (!request.succeeded(response)) {
                throw new FileSystemException("Property '" + attrName + "' could not be set.");
            }
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.webdav/set-attributes", (Throwable)e, new Object[]{this.getName(), attrName});
        }
    }

    private HttpResponse executeRequest(HttpUriRequest request) throws FileSystemException {
        try {
            HttpResponse response = this.executeHttpUriRequest(request);
            int status = response.getStatusLine().getStatusCode();
            if (status == 404 || status == 410) {
                throw new FileNotFoundException((Object)request.getURI());
            }
            if (request instanceof BaseDavRequest) {
                ((BaseDavRequest)request).checkSuccess(response);
            }
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (IOException e) {
            throw new FileSystemException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request instanceof HttpRequestBase) {
                ((HttpRequestBase)request).releaseConnection();
            }
        }
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new Webdav4FileContentInfoFactory();
    }

    DavPropertySet getProperties(GenericURLFileName name) throws FileSystemException {
        return this.getProperties(name, 1, new DavPropertyNameSet(), false);
    }

    DavPropertySet getProperties(GenericURLFileName name, DavPropertyNameSet nameSet, boolean addEncoding) throws FileSystemException {
        return this.getProperties(name, 0, nameSet, addEncoding);
    }

    DavPropertySet getProperties(GenericURLFileName name, int type, DavPropertyNameSet nameSet, boolean addEncoding) throws FileSystemException {
        try {
            String urlStr = this.toUrlString(name);
            HttpPropfind request = new HttpPropfind(urlStr, type, nameSet, 0);
            this.setupRequest((HttpUriRequest)request);
            HttpResponse res = this.executeRequest((HttpUriRequest)request);
            if (request.succeeded(res)) {
                MultiStatus multiStatus = request.getResponseBodyAsMultiStatus(res);
                MultiStatusResponse response = multiStatus.getResponses()[0];
                DavPropertySet props = response.getProperties(200);
                if (addEncoding) {
                    ContentType resContentType = ContentType.getOrDefault((HttpEntity)res.getEntity());
                    DefaultDavProperty prop = new DefaultDavProperty(RESPONSE_CHARSET, (Object)resContentType.getCharset().name());
                    props.add((DavProperty)prop);
                }
                return props;
            }
            return new DavPropertySet();
        }
        catch (FileSystemException fse) {
            throw fse;
        }
        catch (Exception e) {
            throw new FileSystemException("vfs.provider.webdav/get-property.error", (Throwable)e, new Object[]{this.getName(), name, type, nameSet.getContent(), addEncoding});
        }
    }

    DavProperty<?> getProperty(GenericURLFileName fileName, DavPropertyName name) throws FileSystemException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(name);
        DavPropertySet propertySet = this.getProperties(fileName, nameSet, false);
        return propertySet.get(name);
    }

    DavProperty<?> getProperty(GenericURLFileName fileName, String property) throws FileSystemException {
        return this.getProperty(fileName, DavPropertyName.create((String)property));
    }

    DavPropertySet getPropertyNames(GenericURLFileName name) throws FileSystemException {
        return this.getProperties(name, 2, new DavPropertyNameSet(), false);
    }

    private String hrefString(GenericURLFileName name) {
        try {
            GenericURLFileName newFile = new GenericURLFileName(this.getInternalURI().getScheme(), name.getHostName(), name.getPort(), name.getDefaultPort(), null, null, name.getPath(), name.getType(), name.getQueryString());
            return newFile.getURIEncoded(this.getUrlCharset());
        }
        catch (Exception e) {
            return name.getURI();
        }
    }

    private boolean isCurrentFile(String href, GenericURLFileName fileName) {
        String name = this.hrefString(fileName);
        if (href.endsWith("/") && !name.endsWith("/")) {
            name = name + "/";
        }
        return href.equals(name) || href.equals(fileName.getPath());
    }

    private boolean isDirectory(GenericURLFileName name) throws IOException {
        try {
            Node node;
            DavProperty<?> property = this.getProperty(name, "resourcetype");
            if (property != null && (node = (Node)property.getValue()) != null) {
                return node.getLocalName().equals("collection");
            }
            return false;
        }
        catch (FileNotFoundException fse) {
            throw new FileNotFolderException((Object)name);
        }
    }

    private String resourceName(String path) {
        int i;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return (i = path.lastIndexOf("/")) >= 0 ? path.substring(i + 1) : path;
    }

    private void setupRequest(HttpUriRequest request) {
        request.addHeader("Cache-control", "no-cache");
        request.addHeader("Cache-store", "no-store");
        request.addHeader("Pragma", "no-cache");
        request.addHeader("Expires", "0");
    }

    String toUrlString(GenericURLFileName name) {
        return this.toUrlString(name, true);
    }

    private String toUrlString(GenericURLFileName name, boolean includeUserInfo) {
        String user = null;
        String password = null;
        if (includeUserInfo) {
            user = name.getUserName();
            password = name.getPassword();
        }
        try {
            GenericURLFileName newFile = new GenericURLFileName(this.getInternalURI().getScheme(), name.getHostName(), name.getPort(), name.getDefaultPort(), user, password, name.getPath(), name.getType(), name.getQueryString());
            return newFile.getURIEncoded(this.getUrlCharset());
        }
        catch (Exception e) {
            return name.getURI();
        }
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        private final Webdav4FileObject file;

        public WebdavOutputStream(Webdav4FileObject file) {
            super((OutputStream)new ByteArrayOutputStream());
            this.file = file;
        }

        private boolean createVersion(String urlStr) {
            try {
                HttpVersionControl request = new HttpVersionControl(urlStr);
                Webdav4FileObject.this.setupRequest((HttpUriRequest)request);
                Webdav4FileObject.this.executeRequest((HttpUriRequest)request);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }

        protected void onClose() throws IOException {
            ByteArrayEntity entity = new ByteArrayEntity(((ByteArrayOutputStream)this.out).toByteArray());
            GenericURLFileName fileName = (GenericURLFileName)Webdav4FileObject.this.getName();
            String urlStr = Webdav4FileObject.this.toUrlString(fileName);
            if (Webdav4FileObject.this.builder.isVersioning(Webdav4FileObject.this.getFileSystem().getFileSystemOptions())) {
                HttpPut request;
                boolean isCheckedIn;
                boolean fileExists;
                block21: {
                    DavPropertySet set = null;
                    fileExists = true;
                    isCheckedIn = true;
                    try {
                        set = Webdav4FileObject.this.getPropertyNames(fileName);
                    }
                    catch (FileNotFoundException fnfe) {
                        fileExists = false;
                    }
                    if (fileExists && set != null) {
                        DavProperty<?> prop;
                        if (set.contains(VersionControlledResource.CHECKED_OUT)) {
                            isCheckedIn = false;
                        } else if (!set.contains(VersionControlledResource.CHECKED_IN) && (prop = set.get(VersionControlledResource.AUTO_VERSION)) != null && "checkout-checkin".equals((prop = Webdav4FileObject.this.getProperty(fileName, VersionControlledResource.AUTO_VERSION)).getValue())) {
                            this.createVersion(urlStr);
                        }
                    }
                    if (fileExists && isCheckedIn) {
                        try {
                            request = new HttpCheckout(urlStr);
                            Webdav4FileObject.this.setupRequest((HttpUriRequest)request);
                            Webdav4FileObject.this.executeRequest((HttpUriRequest)request);
                            isCheckedIn = false;
                        }
                        catch (FileSystemException ex) {
                            Webdav4FileObject.this.log((Exception)((Object)ex));
                        }
                    }
                    try {
                        request = new HttpPut(urlStr);
                        request.setEntity((HttpEntity)entity);
                        Webdav4FileObject.this.setupRequest((HttpUriRequest)request);
                        Webdav4FileObject.this.executeRequest((HttpUriRequest)request);
                        this.setUserName(fileName, urlStr);
                    }
                    catch (FileSystemException ex) {
                        if (isCheckedIn) break block21;
                        try {
                            HttpCheckin request2 = new HttpCheckin(urlStr);
                            Webdav4FileObject.this.setupRequest((HttpUriRequest)request2);
                            Webdav4FileObject.this.executeRequest((HttpUriRequest)request2);
                            isCheckedIn = true;
                        }
                        catch (Exception e) {
                            Webdav4FileObject.this.log(e);
                        }
                        throw ex;
                    }
                }
                if (!fileExists) {
                    this.createVersion(urlStr);
                    try {
                        DavPropertySet props = Webdav4FileObject.this.getPropertyNames(fileName);
                        isCheckedIn = !props.contains(VersionControlledResource.CHECKED_OUT);
                    }
                    catch (FileNotFoundException fnfe) {
                        Webdav4FileObject.this.log((Exception)((Object)fnfe));
                    }
                }
                if (!isCheckedIn) {
                    request = new HttpCheckin(urlStr);
                    Webdav4FileObject.this.setupRequest((HttpUriRequest)request);
                    Webdav4FileObject.this.executeRequest((HttpUriRequest)request);
                }
            } else {
                HttpPut request = new HttpPut(urlStr);
                request.setEntity((HttpEntity)entity);
                Webdav4FileObject.this.setupRequest((HttpUriRequest)request);
                Webdav4FileObject.this.executeRequest((HttpUriRequest)request);
                try {
                    this.setUserName(fileName, urlStr);
                }
                catch (IOException e) {
                    Webdav4FileObject.this.log(e);
                }
            }
            ((DefaultFileContent)this.file.getContent()).resetAttributes();
        }

        private void setUserName(GenericURLFileName fileName, String urlStr) throws IOException {
            DavPropertySet setProperties = new DavPropertySet();
            DavPropertyNameSet removeProperties = new DavPropertyNameSet();
            String name = Webdav4FileObject.this.builder.getCreatorName(Webdav4FileObject.this.getFileSystem().getFileSystemOptions());
            String userName = fileName.getUserName();
            if (name == null) {
                name = userName;
            } else if (userName != null) {
                String comment = "Modified by user " + userName;
                setProperties.add((DavProperty)new DefaultDavProperty(DeltaVConstants.COMMENT, (Object)comment));
            }
            setProperties.add((DavProperty)new DefaultDavProperty(DeltaVConstants.CREATOR_DISPLAYNAME, (Object)name));
            HttpProppatch request = new HttpProppatch(urlStr, setProperties, removeProperties);
            Webdav4FileObject.this.setupRequest((HttpUriRequest)request);
            Webdav4FileObject.this.executeRequest((HttpUriRequest)request);
        }
    }
}

