/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.example;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.StringTokenizer;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileContent;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.FileUtil;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.operations.FileOperationProvider;

public final class Shell {
    private final FileSystemManager mgr = VFS.getManager();
    private FileObject cwd = this.mgr.toFileObject(new File(System.getProperty("user.dir")));
    private final BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));

    private Shell() throws IOException {
    }

    public static void main(String[] args) {
        try {
            new Shell().go();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private void go() throws Exception {
        System.out.println("VFS Shell " + Shell.getVersion(Shell.class));
        String[] cmd;
        while ((cmd = this.nextCommand()) != null) {
            if (cmd.length == 0) continue;
            String cmdName = cmd[0];
            if (cmdName.equalsIgnoreCase("exit") || cmdName.equalsIgnoreCase("quit")) {
                return;
            }
            try {
                this.handleCommand(cmd);
                continue;
            }
            catch (Exception e) {
                System.err.println("Command failed:");
                e.printStackTrace(System.err);
                continue;
            }
            break;
        }
        return;
    }

    private void handleCommand(String[] cmd) throws Exception {
        String cmdName = cmd[0];
        if (cmdName.equalsIgnoreCase("cat")) {
            this.cat(cmd);
        } else if (cmdName.equalsIgnoreCase("cd")) {
            this.cd(cmd);
        } else if (cmdName.equalsIgnoreCase("cp")) {
            this.cp(cmd);
        } else if (cmdName.equalsIgnoreCase("help") || cmdName.equals("?")) {
            this.help();
        } else if (cmdName.equalsIgnoreCase("ls")) {
            this.ls(cmd);
        } else if (cmdName.equalsIgnoreCase("pwd")) {
            this.pwd();
        } else if (cmdName.equalsIgnoreCase("rm")) {
            this.rm(cmd);
        } else if (cmdName.equalsIgnoreCase("touch")) {
            this.touch(cmd);
        } else if (cmdName.equalsIgnoreCase("info")) {
            this.info(cmd);
        } else {
            System.err.println("Unknown command \"" + cmdName + "\" (Try 'help').");
        }
    }

    private void info(String[] cmd) throws Exception {
        if (cmd.length > 1) {
            this.info(cmd[1]);
        } else {
            System.out.println("Default manager: \"" + this.mgr.getClass().getName() + "\" " + "version " + Shell.getVersion(this.mgr.getClass()));
            String[] schemes = this.mgr.getSchemes();
            ArrayList<String> virtual = new ArrayList<String>();
            ArrayList<String> physical = new ArrayList<String>();
            for (int i = 0; i < schemes.length; ++i) {
                Collection caps = this.mgr.getProviderCapabilities(schemes[i]);
                if (caps == null) continue;
                if (caps.contains(Capability.VIRTUAL) || caps.contains(Capability.COMPRESS) || caps.contains(Capability.DISPATCHER)) {
                    virtual.add(schemes[i]);
                    continue;
                }
                physical.add(schemes[i]);
            }
            if (!physical.isEmpty()) {
                System.out.println("  Provider Schemes: " + physical);
            }
            if (!virtual.isEmpty()) {
                System.out.println("   Virtual Schemes: " + virtual);
            }
        }
    }

    private void info(String scheme) throws Exception {
        FileOperationProvider[] ops;
        System.out.println("Provider Info for scheme \"" + scheme + "\":");
        Collection caps = this.mgr.getProviderCapabilities(scheme);
        if (caps != null && !caps.isEmpty()) {
            System.out.println("  capabilities: " + caps);
        }
        if ((ops = this.mgr.getOperationProviders(scheme)) != null && ops.length > 0) {
            System.out.println("  operations: " + ops);
        }
    }

    private void help() {
        System.out.println("Commands:");
        System.out.println("cat <file>         Displays the contents of a file.");
        System.out.println("cd [folder]        Changes current folder.");
        System.out.println("cp <src> <dest>    Copies a file or folder.");
        System.out.println("help               Shows this message.");
        System.out.println("info [scheme]      Displays information about providers.");
        System.out.println("ls [-R] [path]     Lists contents of a file or folder.");
        System.out.println("pwd                Displays current folder.");
        System.out.println("rm <path>          Deletes a file or folder.");
        System.out.println("touch <path>       Sets the last-modified time of a file.");
        System.out.println("exit, quit         Exits this program.");
    }

    private void rm(String[] cmd) throws Exception {
        if (cmd.length < 2) {
            throw new Exception("USAGE: rm <path>");
        }
        FileObject file = this.mgr.resolveFile(this.cwd, cmd[1]);
        file.delete(Selectors.SELECT_SELF);
    }

    private void cp(String[] cmd) throws Exception {
        if (cmd.length < 3) {
            throw new Exception("USAGE: cp <src> <dest>");
        }
        FileObject src = this.mgr.resolveFile(this.cwd, cmd[1]);
        FileObject dest = this.mgr.resolveFile(this.cwd, cmd[2]);
        if (dest.exists() && dest.getType() == FileType.FOLDER) {
            dest = dest.resolveFile(src.getName().getBaseName());
        }
        dest.copyFrom(src, Selectors.SELECT_ALL);
    }

    private void cat(String[] cmd) throws Exception {
        if (cmd.length < 2) {
            throw new Exception("USAGE: cat <path>");
        }
        FileObject file = this.mgr.resolveFile(this.cwd, cmd[1]);
        FileUtil.writeContent((FileObject)file, (OutputStream)System.out);
        System.out.println();
    }

    private void pwd() {
        System.out.println("Current folder is " + this.cwd.getName());
    }

    private void cd(String[] cmd) throws Exception {
        String path = cmd.length > 1 ? cmd[1] : System.getProperty("user.home");
        FileObject tmp = this.mgr.resolveFile(this.cwd, path);
        if (tmp.exists()) {
            this.cwd = tmp;
        } else {
            System.out.println("Folder does not exist: " + tmp.getName());
        }
        System.out.println("Current folder is " + this.cwd.getName());
    }

    private void ls(String[] cmd) throws FileSystemException {
        boolean recursive;
        int pos = 1;
        if (cmd.length > pos && cmd[pos].equals("-R")) {
            recursive = true;
            ++pos;
        } else {
            recursive = false;
        }
        FileObject file = cmd.length > pos ? this.mgr.resolveFile(this.cwd, cmd[pos]) : this.cwd;
        if (file.getType() == FileType.FOLDER) {
            System.out.println("Contents of " + file.getName());
            this.listChildren(file, recursive, "");
        } else {
            System.out.println(file.getName());
            FileContent content = file.getContent();
            System.out.println("Size: " + content.getSize() + " bytes.");
            DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2);
            String lastMod = dateFormat.format(new Date(content.getLastModifiedTime()));
            System.out.println("Last modified: " + lastMod);
        }
    }

    private void touch(String[] cmd) throws Exception {
        if (cmd.length < 2) {
            throw new Exception("USAGE: touch <path>");
        }
        FileObject file = this.mgr.resolveFile(this.cwd, cmd[1]);
        if (!file.exists()) {
            file.createFile();
        }
        file.getContent().setLastModifiedTime(System.currentTimeMillis());
    }

    private void listChildren(FileObject dir, boolean recursive, String prefix) throws FileSystemException {
        FileObject[] children;
        for (FileObject child : children = dir.getChildren()) {
            System.out.print(prefix);
            System.out.print(child.getName().getBaseName());
            if (child.getType() == FileType.FOLDER) {
                System.out.println("/");
                if (!recursive) continue;
                this.listChildren(child, recursive, prefix + "    ");
                continue;
            }
            System.out.println();
        }
    }

    private String[] nextCommand() throws IOException {
        System.out.print("> ");
        String line = this.reader.readLine();
        if (line == null) {
            return null;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(line);
        while (tokens.hasMoreTokens()) {
            cmd.add(tokens.nextToken());
        }
        return cmd.toArray(new String[cmd.size()]);
    }

    private static String getVersion(Class<?> cls) {
        try {
            return cls.getPackage().getImplementationVersion();
        }
        catch (Exception ignored) {
            return "N/A";
        }
    }
}

