/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.beta.translate;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.text.beta.translate.CharSequenceTranslator;

public class SingleLookupTranslator
extends CharSequenceTranslator {
    private final Map<String, String> lookupMap;
    private final HashSet<Character> prefixSet;
    private final int shortest;
    private final int longest;
    private final int shortestValue;
    private final int longestValue;

    public SingleLookupTranslator(Map<CharSequence, CharSequence> ... inputMaps) {
        HashMap<CharSequence, CharSequence> lookup = new HashMap<CharSequence, CharSequence>();
        for (Map<CharSequence, CharSequence> input : inputMaps) {
            for (Map.Entry<CharSequence, CharSequence> entry : input.entrySet()) {
                lookup.put(entry.getKey(), entry.getValue());
            }
        }
        this.lookupMap = new HashMap<String, String>();
        this.prefixSet = new HashSet();
        int _shortest = Integer.MAX_VALUE;
        int _longest = 0;
        int _shortestValue = Integer.MAX_VALUE;
        int _longestValue = 0;
        if (lookup != null) {
            for (Map.Entry<CharSequence, CharSequence> entry : lookup.entrySet()) {
                int sizeOfValue;
                this.lookupMap.put(entry.getKey().toString(), entry.getValue().toString().toString());
                this.prefixSet.add(Character.valueOf(entry.getKey().charAt(0)));
                int sz = entry.getKey().length();
                if (sz < _shortest) {
                    _shortest = sz;
                }
                if (sz > _longest) {
                    _longest = sz;
                }
                if ((sizeOfValue = ((CharSequence)lookup.get(entry.getKey())).length()) < _shortestValue) {
                    _shortestValue = sizeOfValue;
                }
                if (sizeOfValue <= _longestValue) continue;
                _longestValue = sizeOfValue;
            }
        }
        this.shortest = _shortest;
        this.longest = _longest;
        this.shortestValue = _shortestValue;
        this.longestValue = _longestValue;
    }

    @Override
    public int translate(CharSequence input, int index, Writer out) throws IOException {
        int maxValue = this.longestValue;
        if (index + maxValue > input.length()) {
            maxValue = input.length() - index;
        }
        for (int i = maxValue; i >= this.shortestValue; --i) {
            CharSequence subSeq = input.subSequence(index, index + i);
            if (!this.lookupMap.containsValue(subSeq.toString())) continue;
            return 0;
        }
        if (this.prefixSet.contains(Character.valueOf(input.charAt(index)))) {
            int max = this.longest;
            if (index + this.longest > input.length()) {
                max = input.length() - index;
            }
            for (int i = max; i >= this.shortest; --i) {
                CharSequence subSeq = input.subSequence(index, index + i);
                String result = this.lookupMap.get(subSeq.toString());
                if (result == null) continue;
                out.write(result);
                return i;
            }
        }
        return 0;
    }
}

