/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.RejectionInversionZipfSampler;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class ZipfDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfElements;
    private final double exponent;
    private final double nthHarmonic;

    public ZipfDistribution(int numberOfElements, double exponent) {
        if (numberOfElements <= 0) {
            throw new DistributionException("Number %s is not greater than 0", numberOfElements);
        }
        if (exponent <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", exponent);
        }
        this.numberOfElements = numberOfElements;
        this.exponent = exponent;
        this.nthHarmonic = ZipfDistribution.generalizedHarmonic(numberOfElements, exponent);
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public double getExponent() {
        return this.exponent;
    }

    @Override
    public double probability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return 0.0;
        }
        return 1.0 / Math.pow(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double logProbability(int x) {
        if (x <= 0 || x > this.numberOfElements) {
            return Double.NEGATIVE_INFINITY;
        }
        return -Math.log(x) * this.exponent - Math.log(this.nthHarmonic);
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x <= 0) {
            return 0.0;
        }
        if (x >= this.numberOfElements) {
            return 1.0;
        }
        return ZipfDistribution.generalizedHarmonic(x, this.exponent) / this.nthHarmonic;
    }

    @Override
    public double getMean() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs1 = ZipfDistribution.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs1 / Hs;
    }

    @Override
    public double getVariance() {
        int N = this.getNumberOfElements();
        double s = this.getExponent();
        double Hs2 = ZipfDistribution.generalizedHarmonic(N, s - 2.0);
        double Hs1 = ZipfDistribution.generalizedHarmonic(N, s - 1.0);
        double Hs = this.nthHarmonic;
        return Hs2 / Hs - Hs1 * Hs1 / (Hs * Hs);
    }

    private static double generalizedHarmonic(int n, double m) {
        double value = 0.0;
        for (int k = n; k > 0; --k) {
            value += 1.0 / Math.pow(k, m);
        }
        return value;
    }

    @Override
    public int getSupportLowerBound() {
        return 1;
    }

    @Override
    public int getSupportUpperBound() {
        return this.getNumberOfElements();
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((RejectionInversionZipfSampler)new RejectionInversionZipfSampler(rng, this.numberOfElements, this.exponent)).sample();
    }
}

