/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class UniformContinuousDistribution
extends AbstractContinuousDistribution {
    private final double lower;
    private final double upper;

    public UniformContinuousDistribution(double lower, double upper) {
        if (lower >= upper) {
            throw new DistributionException("Lower bound %s >= upper bound %s", lower, upper);
        }
        this.lower = lower;
        this.upper = upper;
    }

    @Override
    public double density(double x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return 1.0 / (this.upper - this.lower);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.lower) {
            return 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return (x - this.lower) / (this.upper - this.lower);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        return p * (this.upper - this.lower) + this.lower;
    }

    @Override
    public double getMean() {
        return 0.5 * (this.lower + this.upper);
    }

    @Override
    public double getVariance() {
        double ul = this.upper - this.lower;
        return ul * ul / 12.0;
    }

    @Override
    public double getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public double getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((ContinuousUniformSampler)new ContinuousUniformSampler(rng, this.lower, this.upper)).sample();
    }
}

