/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.NormalDistribution;

public class TruncatedNormalDistribution
extends AbstractContinuousDistribution {
    private final double parentMean;
    private final double parentSd;
    private final double mean;
    private final double variance;
    private final double lower;
    private final double upper;
    private final NormalDistribution standardNormal;
    private final double cdfAlpha;
    private final double cdfDelta;

    public TruncatedNormalDistribution(double mean, double sd, double lower, double upper) {
        if (sd <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", sd);
        }
        if (lower >= upper) {
            throw new DistributionException("Lower bound %s >= upper bound %s", lower, upper);
        }
        this.lower = lower;
        this.upper = upper;
        this.parentMean = mean;
        this.parentSd = sd;
        this.standardNormal = new NormalDistribution(0.0, 1.0);
        double alpha = (lower - mean) / sd;
        double beta = (upper - mean) / sd;
        double cdfBeta = this.standardNormal.cumulativeProbability(beta);
        this.cdfAlpha = this.standardNormal.cumulativeProbability(alpha);
        this.cdfDelta = cdfBeta - this.cdfAlpha;
        double pdfAlpha = this.standardNormal.density(alpha);
        double pdfBeta = this.standardNormal.density(beta);
        double pdfCdfDelta = (pdfAlpha - pdfBeta) / this.cdfDelta;
        double alphaBetaDelta = (alpha * pdfAlpha - beta * pdfBeta) / this.cdfDelta;
        if (lower == Double.NEGATIVE_INFINITY) {
            if (upper == Double.POSITIVE_INFINITY) {
                this.mean = mean;
                this.variance = sd * sd;
            } else {
                double betaRatio = pdfBeta / cdfBeta;
                this.mean = mean - sd * betaRatio;
                this.variance = sd * sd * (1.0 - beta * betaRatio - betaRatio * betaRatio);
            }
        } else if (upper == Double.POSITIVE_INFINITY) {
            double alphaRatio = pdfAlpha / this.cdfDelta;
            this.mean = mean + sd * alphaRatio;
            this.variance = sd * sd * (1.0 + alpha * alphaRatio - alphaRatio * alphaRatio);
        } else {
            this.mean = mean + pdfCdfDelta * this.parentSd;
            this.variance = sd * sd * (1.0 + alphaBetaDelta - pdfCdfDelta * pdfCdfDelta);
        }
    }

    @Override
    public double density(double x) {
        if (x < this.lower || x > this.upper) {
            return 0.0;
        }
        return this.standardNormal.density((x - this.parentMean) / this.parentSd) / (this.parentSd * this.cdfDelta);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.lower) {
            return 0.0;
        }
        if (x >= this.upper) {
            return 1.0;
        }
        return (this.standardNormal.cumulativeProbability((x - this.parentMean) / this.parentSd) - this.cdfAlpha) / this.cdfDelta;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        return this.standardNormal.inverseCumulativeProbability(this.cdfAlpha + p * this.cdfDelta) * this.parentSd + this.parentMean;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return this.lower;
    }

    @Override
    public double getSupportUpperBound() {
        return this.upper;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

