/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.Erf;
import org.apache.commons.numbers.gamma.LogGamma;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class TDistribution
extends AbstractContinuousDistribution {
    private static final double TWO = 2.0;
    private static final double ONE_OVER_SQRT_TWO = 1.0 / Math.sqrt(2.0);
    private static final double DOF_THRESHOLD_NORMAL = 2990000.0;
    private final double degreesOfFreedom;
    private final double dofOver2;
    private final double factor;
    private final double mean;
    private final double variance;

    public TDistribution(double degreesOfFreedom) {
        if (degreesOfFreedom <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", degreesOfFreedom);
        }
        this.degreesOfFreedom = degreesOfFreedom;
        this.dofOver2 = 0.5 * degreesOfFreedom;
        this.factor = LogGamma.value((double)(this.dofOver2 + 0.5)) - 0.5 * (Math.log(Math.PI) + Math.log(degreesOfFreedom)) - LogGamma.value((double)this.dofOver2);
        if (degreesOfFreedom > 2.0) {
            this.mean = 0.0;
            this.variance = degreesOfFreedom / (degreesOfFreedom - 2.0);
        } else if (degreesOfFreedom > 1.0) {
            this.mean = 0.0;
            this.variance = Double.POSITIVE_INFINITY;
        } else {
            this.mean = Double.NaN;
            this.variance = Double.NaN;
        }
    }

    public double getDegreesOfFreedom() {
        return this.degreesOfFreedom;
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        double nPlus1Over2 = this.dofOver2 + 0.5;
        return this.factor - nPlus1Over2 * Math.log1p(x * x / this.degreesOfFreedom);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x == 0.0) {
            return 0.5;
        }
        if (this.degreesOfFreedom > 2990000.0) {
            return 0.5 * (1.0 + Erf.value((double)(x * ONE_OVER_SQRT_TWO)));
        }
        double a = 1.0 / (1.0 + x * x / this.degreesOfFreedom);
        double t = RegularizedBeta.value((double)a, (double)this.dofOver2, (double)0.5);
        return x < 0.0 ? 0.5 * t : 1.0 - 0.5 * t;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.variance;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

