/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.RegularizedGamma;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.PoissonSampler;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.NormalDistribution;
import org.apache.commons.statistics.distribution.SaddlePointExpansionUtils;

public class PoissonDistribution
extends AbstractDiscreteDistribution {
    private static final double LOG_TWO_PI = Math.log(Math.PI * 2);
    private static final int DEFAULT_MAX_ITERATIONS = 10000000;
    private static final double DEFAULT_EPSILON = 1.0E-12;
    private final NormalDistribution normal;
    private final double mean;
    private final int maxIterations;
    private final double epsilon;

    public PoissonDistribution(double p) {
        this(p, 1.0E-12, 10000000);
    }

    private PoissonDistribution(double p, double epsilon, int maxIterations) {
        if (p <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", p);
        }
        this.mean = p;
        this.epsilon = epsilon;
        this.maxIterations = maxIterations;
        this.normal = new NormalDistribution(p, Math.sqrt(p));
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        double ret = x < 0 || x == Integer.MAX_VALUE ? Double.NEGATIVE_INFINITY : (x == 0 ? -this.mean : -SaddlePointExpansionUtils.getStirlingError(x) - SaddlePointExpansionUtils.getDeviancePart(x, this.mean) - 0.5 * LOG_TWO_PI - 0.5 * Math.log(x));
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        if (x == Integer.MAX_VALUE) {
            return 1.0;
        }
        return RegularizedGamma.Q.value((double)((double)x + 1.0), (double)this.mean, (double)this.epsilon, (int)this.maxIterations);
    }

    public double normalApproximateProbability(int x) {
        return this.normal.cumulativeProbability((double)x + 0.5);
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.getMean();
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public DiscreteDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((PoissonSampler)new PoissonSampler(rng, this.mean)).sample();
    }
}

