/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InverseTransformParetoSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class ParetoDistribution
extends AbstractContinuousDistribution {
    private static final double MIN_SHAPE_FOR_VARIANCE = 2.0;
    private final double scale;
    private final double shape;

    public ParetoDistribution(double scale, double shape) {
        if (scale <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", scale);
        }
        if (shape <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", shape);
        }
        this.scale = scale;
        this.shape = shape;
    }

    public double getScale() {
        return this.scale;
    }

    public double getShape() {
        return this.shape;
    }

    @Override
    public double density(double x) {
        if (x < this.scale) {
            return 0.0;
        }
        return Math.pow(this.scale, this.shape) / Math.pow(x, this.shape + 1.0) * this.shape;
    }

    @Override
    public double logDensity(double x) {
        if (x < this.scale) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.log(this.scale) * this.shape - Math.log(x) * (this.shape + 1.0) + Math.log(this.shape);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.scale) {
            return 0.0;
        }
        return 1.0 - Math.pow(this.scale / x, this.shape);
    }

    @Override
    public double getMean() {
        if (this.shape <= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.shape * this.scale / (this.shape - 1.0);
    }

    @Override
    public double getVariance() {
        if (this.shape <= 2.0) {
            return Double.POSITIVE_INFINITY;
        }
        double s = this.shape - 1.0;
        return this.scale * this.scale * this.shape / (s * s) / (this.shape - 2.0);
    }

    @Override
    public double getSupportLowerBound() {
        return this.getScale();
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((InverseTransformParetoSampler)new InverseTransformParetoSampler(rng, this.scale, this.shape)).sample();
    }
}

