/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class LogisticDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = Double.NEGATIVE_INFINITY;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double PI_SQUARED_OVER_THREE = 3.289868133696453;
    private final double mu;
    private final double scale;
    private final double oneOverScale;

    public LogisticDistribution(double mu, double scale) {
        if (scale <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", scale);
        }
        this.mu = mu;
        this.scale = scale;
        this.oneOverScale = 1.0 / scale;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.scale;
    }

    @Override
    public double density(double x) {
        if (x <= Double.NEGATIVE_INFINITY || x >= Double.POSITIVE_INFINITY) {
            return 0.0;
        }
        double z = this.oneOverScale * (x - this.mu);
        double v = Math.exp(-z);
        return this.oneOverScale * v / ((1.0 + v) * (1.0 + v));
    }

    @Override
    public double cumulativeProbability(double x) {
        double z = this.oneOverScale * (x - this.mu);
        return 1.0 / (1.0 + Math.exp(-z));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        if (p == 0.0) {
            return 0.0;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.scale * Math.log(p / (1.0 - p)) + this.mu;
    }

    @Override
    public double getMean() {
        return this.getLocation();
    }

    @Override
    public double getVariance() {
        return this.scale * this.scale * 3.289868133696453;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

