/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class LaplaceDistribution
extends AbstractContinuousDistribution {
    private final double mu;
    private final double beta;

    public LaplaceDistribution(double mu, double beta) {
        if (beta <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", beta);
        }
        this.mu = mu;
        this.beta = beta;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        return Math.exp(-Math.abs(x - this.mu) / this.beta) / (2.0 * this.beta);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= this.mu) {
            return Math.exp((x - this.mu) / this.beta) / 2.0;
        }
        return 1.0 - Math.exp((this.mu - x) / this.beta) / 2.0;
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        double x = p > 0.5 ? -Math.log(2.0 - 2.0 * p) : Math.log(2.0 * p);
        return this.mu + this.beta * x;
    }

    @Override
    public double getMean() {
        return this.getLocation();
    }

    @Override
    public double getVariance() {
        return 2.0 * this.beta * this.beta;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

