/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class GumbelDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = Double.NEGATIVE_INFINITY;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double PI_SQUARED_OVER_SIX = 1.6449340668482264;
    private static final double EULER = 0.5778636748954609;
    private final double mu;
    private final double beta;

    public GumbelDistribution(double mu, double beta) {
        if (beta <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", beta);
        }
        this.beta = beta;
        this.mu = mu;
    }

    public double getLocation() {
        return this.mu;
    }

    public double getScale() {
        return this.beta;
    }

    @Override
    public double density(double x) {
        if (x <= Double.NEGATIVE_INFINITY) {
            return 0.0;
        }
        double z = (x - this.mu) / this.beta;
        double t = Math.exp(-z);
        return Math.exp(-z - t) / this.beta;
    }

    @Override
    public double cumulativeProbability(double x) {
        double z = (x - this.mu) / this.beta;
        return Math.exp(-Math.exp(-z));
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        if (p == 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (p == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return this.mu - Math.log(-Math.log(p)) * this.beta;
    }

    @Override
    public double getMean() {
        return this.mu + 0.5778636748954609 * this.beta;
    }

    @Override
    public double getVariance() {
        return 1.6449340668482264 * this.beta * this.beta;
    }

    @Override
    public double getSupportLowerBound() {
        return Double.NEGATIVE_INFINITY;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

