/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class GeometricDistribution
extends AbstractDiscreteDistribution {
    private final double probabilityOfSuccess;
    private final double logProbabilityOfSuccess;
    private final double log1mProbabilityOfSuccess;

    public GeometricDistribution(double p) {
        if (p <= 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        this.probabilityOfSuccess = p;
        this.logProbabilityOfSuccess = Math.log(p);
        this.log1mProbabilityOfSuccess = Math.log1p(-p);
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        if (x < 0) {
            return 0.0;
        }
        return Math.exp(this.log1mProbabilityOfSuccess * (double)x) * this.probabilityOfSuccess;
    }

    @Override
    public double logProbability(int x) {
        if (x < 0) {
            return Double.NEGATIVE_INFINITY;
        }
        return (double)x * this.log1mProbabilityOfSuccess + this.logProbabilityOfSuccess;
    }

    @Override
    public double cumulativeProbability(int x) {
        if (x < 0) {
            return 0.0;
        }
        return -Math.expm1(this.log1mProbabilityOfSuccess * (double)(x + 1));
    }

    @Override
    public double getMean() {
        return (1.0 - this.probabilityOfSuccess) / this.probabilityOfSuccess;
    }

    @Override
    public double getVariance() {
        return (1.0 - this.probabilityOfSuccess) / (this.probabilityOfSuccess * this.probabilityOfSuccess);
    }

    @Override
    public int getSupportLowerBound() {
        return 0;
    }

    @Override
    public int getSupportUpperBound() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public int inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        if (p == 1.0) {
            return Integer.MAX_VALUE;
        }
        if (p == 0.0) {
            return 0;
        }
        return Math.max(0, (int)Math.ceil(Math.log1p(-p) / this.log1mProbabilityOfSuccess - 1.0));
    }
}

