/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.LogBeta;
import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class FDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private static final double MIN_DENOMINATOR_DF_FOR_MEAN = 2.0;
    private static final double MIN_DENOMINATOR_DF_FOR_VARIANCE = 4.0;
    private final double numeratorDegreesOfFreedom;
    private final double denominatorDegreesOfFreedom;

    public FDistribution(double numeratorDegreesOfFreedom, double denominatorDegreesOfFreedom) {
        if (numeratorDegreesOfFreedom <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", numeratorDegreesOfFreedom);
        }
        if (denominatorDegreesOfFreedom <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", denominatorDegreesOfFreedom);
        }
        this.numeratorDegreesOfFreedom = numeratorDegreesOfFreedom;
        this.denominatorDegreesOfFreedom = denominatorDegreesOfFreedom;
    }

    @Override
    public double density(double x) {
        return Math.exp(this.logDensity(x));
    }

    @Override
    public double logDensity(double x) {
        if (x <= 0.0 || x >= Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        double nhalf = this.numeratorDegreesOfFreedom / 2.0;
        double mhalf = this.denominatorDegreesOfFreedom / 2.0;
        double logx = Math.log(x);
        double logn = Math.log(this.numeratorDegreesOfFreedom);
        double logm = Math.log(this.denominatorDegreesOfFreedom);
        double lognxm = Math.log(this.numeratorDegreesOfFreedom * x + this.denominatorDegreesOfFreedom);
        return nhalf * logn + nhalf * logx - logx + mhalf * logm - nhalf * lognxm - mhalf * lognxm - LogBeta.value((double)nhalf, (double)mhalf);
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        if (x >= Double.POSITIVE_INFINITY) {
            return 1.0;
        }
        double n = this.numeratorDegreesOfFreedom;
        double m = this.denominatorDegreesOfFreedom;
        return RegularizedBeta.value((double)(n * x / (m + n * x)), (double)(0.5 * n), (double)(0.5 * m));
    }

    public double getNumeratorDegreesOfFreedom() {
        return this.numeratorDegreesOfFreedom;
    }

    public double getDenominatorDegreesOfFreedom() {
        return this.denominatorDegreesOfFreedom;
    }

    @Override
    public double getMean() {
        double denominatorDF = this.getDenominatorDegreesOfFreedom();
        if (denominatorDF > 2.0) {
            return denominatorDF / (denominatorDF - 2.0);
        }
        return Double.NaN;
    }

    @Override
    public double getVariance() {
        double denominatorDF = this.getDenominatorDegreesOfFreedom();
        if (denominatorDF > 4.0) {
            double numeratorDF = this.getNumeratorDegreesOfFreedom();
            double denomDFMinusTwo = denominatorDF - 2.0;
            return 2.0 * (denominatorDF * denominatorDF) * (numeratorDF + denominatorDF - 2.0) / (numeratorDF * (denomDFMinusTwo * denomDFMinusTwo) * (denominatorDF - 4.0));
        }
        return Double.NaN;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

