/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.statistics.distribution.AbstractContinuousDistribution;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

public class ExponentialDistribution
extends AbstractContinuousDistribution {
    private static final double SUPPORT_LO = 0.0;
    private static final double SUPPORT_HI = Double.POSITIVE_INFINITY;
    private final double mean;
    private final double logMean;

    public ExponentialDistribution(double mean) {
        if (mean <= 0.0) {
            throw new DistributionException("Number %s is not greater than 0", mean);
        }
        this.mean = mean;
        this.logMean = Math.log(mean);
    }

    @Override
    public double density(double x) {
        double logDensity = this.logDensity(x);
        return logDensity == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(logDensity);
    }

    @Override
    public double logDensity(double x) {
        if (x < 0.0 || x >= Double.POSITIVE_INFINITY) {
            return Double.NEGATIVE_INFINITY;
        }
        return -x / this.mean - this.logMean;
    }

    @Override
    public double cumulativeProbability(double x) {
        if (x <= 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-x / this.mean);
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        double ret = p == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * Math.log(1.0 - p);
        return ret;
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getVariance() {
        return this.mean * this.mean;
    }

    @Override
    public double getSupportLowerBound() {
        return 0.0;
    }

    @Override
    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((AhrensDieterExponentialSampler)new AhrensDieterExponentialSampler(rng, this.mean)).sample();
    }
}

