/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.gamma.RegularizedBeta;
import org.apache.commons.statistics.distribution.AbstractDiscreteDistribution;
import org.apache.commons.statistics.distribution.DistributionException;
import org.apache.commons.statistics.distribution.SaddlePointExpansionUtils;

public class BinomialDistribution
extends AbstractDiscreteDistribution {
    private final int numberOfTrials;
    private final double probabilityOfSuccess;

    public BinomialDistribution(int trials, double p) {
        if (trials < 0) {
            throw new DistributionException("Number %s is negative", trials);
        }
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        this.probabilityOfSuccess = p;
        this.numberOfTrials = trials;
    }

    public int getNumberOfTrials() {
        return this.numberOfTrials;
    }

    public double getProbabilityOfSuccess() {
        return this.probabilityOfSuccess;
    }

    @Override
    public double probability(int x) {
        double logProbability = this.logProbability(x);
        return logProbability == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(logProbability);
    }

    @Override
    public double logProbability(int x) {
        if (this.numberOfTrials == 0) {
            return x == 0 ? 0.0 : Double.NEGATIVE_INFINITY;
        }
        double ret = x < 0 || x > this.numberOfTrials ? Double.NEGATIVE_INFINITY : SaddlePointExpansionUtils.logBinomialProbability(x, this.numberOfTrials, this.probabilityOfSuccess, 1.0 - this.probabilityOfSuccess);
        return ret;
    }

    @Override
    public double cumulativeProbability(int x) {
        double ret = x < 0 ? 0.0 : (x >= this.numberOfTrials ? 1.0 : 1.0 - RegularizedBeta.value((double)this.probabilityOfSuccess, (double)((double)x + 1.0), (double)((double)this.numberOfTrials - (double)x)));
        return ret;
    }

    @Override
    public double getMean() {
        return (double)this.numberOfTrials * this.probabilityOfSuccess;
    }

    @Override
    public double getVariance() {
        double p = this.probabilityOfSuccess;
        return (double)this.numberOfTrials * p * (1.0 - p);
    }

    @Override
    public int getSupportLowerBound() {
        return this.probabilityOfSuccess < 1.0 ? 0 : this.numberOfTrials;
    }

    @Override
    public int getSupportUpperBound() {
        return this.probabilityOfSuccess > 0.0 ? this.numberOfTrials : 0;
    }

    @Override
    public boolean isSupportConnected() {
        return true;
    }
}

