/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.distribution;

import org.apache.commons.numbers.rootfinder.BrentSolver;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.InverseTransformContinuousSampler;
import org.apache.commons.statistics.distribution.ContinuousDistribution;
import org.apache.commons.statistics.distribution.DistributionException;

abstract class AbstractContinuousDistribution
implements ContinuousDistribution {
    private static final double SOLVER_RELATIVE_ACCURACY = 1.0E-14;
    private static final double SOLVER_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final double SOLVER_FUNCTION_VALUE_ACCURACY = 1.0E-15;

    AbstractContinuousDistribution() {
    }

    @Override
    public double inverseCumulativeProbability(double p) {
        boolean chebyshevApplies;
        if (p < 0.0 || p > 1.0) {
            throw new DistributionException("Not a probability: %s is out of range [0, 1]", p);
        }
        double lowerBound = this.getSupportLowerBound();
        if (p == 0.0) {
            return lowerBound;
        }
        double upperBound = this.getSupportUpperBound();
        if (p == 1.0) {
            return upperBound;
        }
        double mu = this.getMean();
        double sig = Math.sqrt(this.getVariance());
        boolean bl = chebyshevApplies = Double.isFinite(mu) && Double.isFinite(sig);
        if (lowerBound == Double.NEGATIVE_INFINITY) {
            if (chebyshevApplies) {
                lowerBound = mu - sig * Math.sqrt((1.0 - p) / p);
            } else {
                lowerBound = -1.0;
                while (this.cumulativeProbability(lowerBound) >= p) {
                    lowerBound *= 2.0;
                }
            }
        }
        if (upperBound == Double.POSITIVE_INFINITY) {
            if (chebyshevApplies) {
                upperBound = mu + sig * Math.sqrt(p / (1.0 - p));
            } else {
                upperBound = 1.0;
                while (this.cumulativeProbability(upperBound) < p) {
                    upperBound *= 2.0;
                }
            }
        }
        double x = new BrentSolver(1.0E-14, 1.0E-9, 1.0E-15).findRoot(arg -> this.cumulativeProbability(arg) - p, lowerBound, 0.5 * (lowerBound + upperBound), upperBound);
        if (!this.isSupportConnected()) {
            double dx = 1.0E-9;
            if (x - 1.0E-9 >= this.getSupportLowerBound()) {
                double px = this.cumulativeProbability(x);
                if (this.cumulativeProbability(x - 1.0E-9) == px) {
                    upperBound = x;
                    while (upperBound - lowerBound > 1.0E-9) {
                        double midPoint = 0.5 * (lowerBound + upperBound);
                        if (this.cumulativeProbability(midPoint) < px) {
                            lowerBound = midPoint;
                            continue;
                        }
                        upperBound = midPoint;
                    }
                    return upperBound;
                }
            }
        }
        return x;
    }

    public static double[] sample(int n, ContinuousDistribution.Sampler sampler) {
        double[] samples = new double[n];
        for (int i = 0; i < n; ++i) {
            samples[i] = sampler.sample();
        }
        return samples;
    }

    @Override
    public ContinuousDistribution.Sampler createSampler(UniformRandomProvider rng) {
        return () -> ((InverseTransformContinuousSampler)new InverseTransformContinuousSampler(rng, this::inverseCumulativeProbability)).sample();
    }
}

