/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.apache.commons.rng.UniformRandomProvider;

abstract class RngDataOutput
implements Closeable {
    protected final byte[] buffer;
    private final OutputStream out;

    RngDataOutput(OutputStream out, int size) {
        this.out = out;
        this.buffer = new byte[size];
    }

    public void write(UniformRandomProvider rng) throws IOException {
        this.fillBuffer(rng);
        this.out.write(this.buffer);
    }

    public abstract void fillBuffer(UniformRandomProvider var1);

    final void writeIntBE(int index, int value) {
        this.buffer[index] = (byte)(value >>> 24);
        this.buffer[index + 1] = (byte)(value >>> 16);
        this.buffer[index + 2] = (byte)(value >>> 8);
        this.buffer[index + 3] = (byte)value;
    }

    final void writeIntLE(int index, int value) {
        this.buffer[index] = (byte)value;
        this.buffer[index + 1] = (byte)(value >>> 8);
        this.buffer[index + 2] = (byte)(value >>> 16);
        this.buffer[index + 3] = (byte)(value >>> 24);
    }

    final void writeLongBE(int index, long value) {
        this.buffer[index] = (byte)(value >>> 56);
        this.buffer[index + 1] = (byte)(value >>> 48);
        this.buffer[index + 2] = (byte)(value >>> 40);
        this.buffer[index + 3] = (byte)(value >>> 32);
        this.buffer[index + 4] = (byte)(value >>> 24);
        this.buffer[index + 5] = (byte)(value >>> 16);
        this.buffer[index + 6] = (byte)(value >>> 8);
        this.buffer[index + 7] = (byte)value;
    }

    final void writeLongLE(int index, long value) {
        this.buffer[index] = (byte)value;
        this.buffer[index + 1] = (byte)(value >>> 8);
        this.buffer[index + 2] = (byte)(value >>> 16);
        this.buffer[index + 3] = (byte)(value >>> 24);
        this.buffer[index + 4] = (byte)(value >>> 32);
        this.buffer[index + 5] = (byte)(value >>> 40);
        this.buffer[index + 6] = (byte)(value >>> 48);
        this.buffer[index + 7] = (byte)(value >>> 56);
    }

    final void writeLongAsIntLE(int index, long value) {
        this.buffer[index] = (byte)(value >>> 32);
        this.buffer[index + 1] = (byte)(value >>> 40);
        this.buffer[index + 2] = (byte)(value >>> 48);
        this.buffer[index + 3] = (byte)(value >>> 56);
        this.buffer[index + 4] = (byte)value;
        this.buffer[index + 5] = (byte)(value >>> 8);
        this.buffer[index + 6] = (byte)(value >>> 16);
        this.buffer[index + 7] = (byte)(value >>> 24);
    }

    @Override
    public void close() throws IOException {
        try (OutputStream ostream = this.out;){
            ostream.flush();
        }
    }

    static RngDataOutput ofInt(OutputStream out, int size, ByteOrder byteOrder) {
        int bytes = Math.max(size * 4, 4);
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? new LIntRngDataOutput(out, bytes) : new BIntRngDataOutput(out, bytes);
    }

    static RngDataOutput ofLong(OutputStream out, int size, ByteOrder byteOrder) {
        int bytes = Math.max(size * 8, 8);
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? new LLongRngDataOutput(out, bytes) : new BLongRngDataOutput(out, bytes);
    }

    static RngDataOutput ofLongAsInt(OutputStream out, int size, ByteOrder byteOrder) {
        int bytes = Math.max(size * 8, 8);
        return byteOrder == ByteOrder.LITTLE_ENDIAN ? new LLongAsIntRngDataOutput(out, bytes) : new BLongRngDataOutput(out, bytes);
    }

    private static class LLongAsIntRngDataOutput
    extends RngDataOutput {
        LLongAsIntRngDataOutput(OutputStream out, int size) {
            super(out, size);
        }

        @Override
        public void fillBuffer(UniformRandomProvider rng) {
            for (int i = 0; i < this.buffer.length; i += 8) {
                this.writeLongAsIntLE(i, rng.nextLong());
            }
        }
    }

    private static class LLongRngDataOutput
    extends RngDataOutput {
        LLongRngDataOutput(OutputStream out, int size) {
            super(out, size);
        }

        @Override
        public void fillBuffer(UniformRandomProvider rng) {
            for (int i = 0; i < this.buffer.length; i += 8) {
                this.writeLongLE(i, rng.nextLong());
            }
        }
    }

    private static class BLongRngDataOutput
    extends RngDataOutput {
        BLongRngDataOutput(OutputStream out, int size) {
            super(out, size);
        }

        @Override
        public void fillBuffer(UniformRandomProvider rng) {
            for (int i = 0; i < this.buffer.length; i += 8) {
                this.writeLongBE(i, rng.nextLong());
            }
        }
    }

    private static class LIntRngDataOutput
    extends RngDataOutput {
        LIntRngDataOutput(OutputStream out, int size) {
            super(out, size);
        }

        @Override
        public void fillBuffer(UniformRandomProvider rng) {
            for (int i = 0; i < this.buffer.length; i += 4) {
                this.writeIntLE(i, rng.nextInt());
            }
        }
    }

    private static class BIntRngDataOutput
    extends RngDataOutput {
        BIntRngDataOutput(OutputStream out, int size) {
            super(out, size);
        }

        @Override
        public void fillBuffer(UniformRandomProvider rng) {
            for (int i = 0; i < this.buffer.length; i += 4) {
                this.writeIntBE(i, rng.nextInt());
            }
        }
    }
}

