/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.core.source32.RandomIntSource;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.source64.RandomLongSource;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.examples.stress.ApplicationException;
import org.apache.commons.rng.examples.stress.RngDataOutput;

final class RNGUtils {
    private static final String BYTE_REVERSED = "Byte-reversed ";
    private static final String BIT_REVERSED = "Bit-reversed ";
    private static final String HASH_CODE = "HashCode ^ ";
    private static final String TLR_MIXED = "ThreadLocalRandom ^ ";
    private static final String XOR = " ^ ";
    private static final String UNRECOGNISED_NATIVE_TYPE = "Unrecognised native output type: ";
    private static final String NOT_LONG_SOURCE = "Not a 64-bit long generator: ";

    private RNGUtils() {
    }

    static UniformRandomProvider createReverseBytesProvider(final UniformRandomProvider rng) {
        if (rng instanceof RandomIntSource) {
            return new IntProvider(){

                public int next() {
                    return Integer.reverseBytes(rng.nextInt());
                }

                public String toString() {
                    return RNGUtils.BYTE_REVERSED + rng.toString();
                }
            };
        }
        if (rng instanceof RandomLongSource) {
            return new LongProvider(){

                public long next() {
                    return Long.reverseBytes(rng.nextLong());
                }

                public String toString() {
                    return RNGUtils.BYTE_REVERSED + rng.toString();
                }
            };
        }
        throw new ApplicationException(UNRECOGNISED_NATIVE_TYPE + rng);
    }

    static UniformRandomProvider createReverseBitsProvider(final UniformRandomProvider rng) {
        if (rng instanceof RandomIntSource) {
            return new IntProvider(){

                public int next() {
                    return Integer.reverse(rng.nextInt());
                }

                public String toString() {
                    return RNGUtils.BIT_REVERSED + rng.toString();
                }
            };
        }
        if (rng instanceof RandomLongSource) {
            return new LongProvider(){

                public long next() {
                    return Long.reverse(rng.nextLong());
                }

                public String toString() {
                    return RNGUtils.BIT_REVERSED + rng.toString();
                }
            };
        }
        throw new ApplicationException(UNRECOGNISED_NATIVE_TYPE + rng);
    }

    static UniformRandomProvider createIntProvider(final UniformRandomProvider rng) {
        if (!(rng instanceof RandomIntSource)) {
            return new IntProvider(){

                public int next() {
                    return rng.nextInt();
                }

                public String toString() {
                    return "Int bits " + rng.toString();
                }
            };
        }
        return rng;
    }

    static UniformRandomProvider createLongUpperBitsIntProvider(final UniformRandomProvider rng) {
        if (rng instanceof RandomLongSource) {
            return new IntProvider(){

                public int next() {
                    return (int)(rng.nextLong() >>> 32);
                }

                public String toString() {
                    return "Long upper-bits " + rng.toString();
                }
            };
        }
        throw new ApplicationException(NOT_LONG_SOURCE + rng);
    }

    static UniformRandomProvider createLongLowerBitsIntProvider(final UniformRandomProvider rng) {
        if (rng instanceof RandomLongSource) {
            return new IntProvider(){

                public int next() {
                    return (int)rng.nextLong();
                }

                public String toString() {
                    return "Long lower-bits " + rng.toString();
                }
            };
        }
        throw new ApplicationException(NOT_LONG_SOURCE + rng);
    }

    static UniformRandomProvider createHashCodeProvider(final UniformRandomProvider rng) {
        if (rng instanceof RandomIntSource) {
            return new IntProvider(){

                public int next() {
                    return System.identityHashCode(new Object()) ^ rng.nextInt();
                }

                public String toString() {
                    return RNGUtils.HASH_CODE + rng.toString();
                }
            };
        }
        if (rng instanceof RandomLongSource) {
            return new LongProvider(){

                public long next() {
                    long mix = NumberFactory.makeLong((int)System.identityHashCode(new Object()), (int)System.identityHashCode(new Object()));
                    return mix ^ rng.nextLong();
                }

                public String toString() {
                    return RNGUtils.HASH_CODE + rng.toString();
                }
            };
        }
        throw new ApplicationException(UNRECOGNISED_NATIVE_TYPE + rng);
    }

    static UniformRandomProvider createThreadLocalRandomProvider(final UniformRandomProvider rng) {
        if (rng instanceof RandomIntSource) {
            return new IntProvider(){

                public int next() {
                    return ThreadLocalRandom.current().nextInt() ^ rng.nextInt();
                }

                public String toString() {
                    return RNGUtils.TLR_MIXED + rng.toString();
                }
            };
        }
        if (rng instanceof RandomLongSource) {
            return new LongProvider(){

                public long next() {
                    return ThreadLocalRandom.current().nextLong() ^ rng.nextLong();
                }

                public String toString() {
                    return RNGUtils.TLR_MIXED + rng.toString();
                }
            };
        }
        throw new ApplicationException(UNRECOGNISED_NATIVE_TYPE + rng);
    }

    static UniformRandomProvider createXorProvider(final UniformRandomProvider rng1, final UniformRandomProvider rng2) {
        if (rng1 instanceof RandomIntSource) {
            return new IntProvider(){

                public int next() {
                    return rng1.nextInt() ^ rng2.nextInt();
                }

                public String toString() {
                    return rng1.toString() + RNGUtils.XOR + rng2.toString();
                }
            };
        }
        if (rng1 instanceof RandomLongSource) {
            return new LongProvider(){

                public long next() {
                    return rng1.nextLong() ^ rng2.nextLong();
                }

                public String toString() {
                    return rng1.toString() + RNGUtils.XOR + rng2.toString();
                }
            };
        }
        throw new ApplicationException(UNRECOGNISED_NATIVE_TYPE + rng1);
    }

    static RngDataOutput createDataOutput(UniformRandomProvider rng, boolean raw64, OutputStream out, int byteSize, ByteOrder byteOrder) {
        if (rng instanceof RandomIntSource) {
            return RngDataOutput.ofInt(out, byteSize / 4, byteOrder);
        }
        if (rng instanceof RandomLongSource) {
            return raw64 ? RngDataOutput.ofLong(out, byteSize / 8, byteOrder) : RngDataOutput.ofLongAsInt(out, byteSize / 8, byteOrder);
        }
        throw new ApplicationException(UNRECOGNISED_NATIVE_TYPE + rng);
    }

    static Object parseArgument(String argument) {
        try {
            return Integer.parseInt(argument);
        }
        catch (NumberFormatException ex) {
            throw new ApplicationException("Failed to parse RandomSource argument: " + argument, ex);
        }
    }
}

