/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

final class Hex {
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private Hex() {
    }

    static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        for (int i = 0; i < l; ++i) {
            out[2 * i] = HEX_DIGITS[(0xF0 & data[i]) >>> 4];
            out[2 * i + 1] = HEX_DIGITS[0xF & data[i]];
        }
        return out;
    }

    public static byte[] decodeHex(CharSequence data) {
        int len = data.length();
        if ((len & 1) != 0) {
            throw new IllegalArgumentException("Odd number of characters.");
        }
        byte[] out = new byte[len >> 1];
        for (int j = 0; j < len; j += 2) {
            int f = Hex.toDigit(data, j) << 4 | Hex.toDigit(data, j + 1);
            out[j / 2] = (byte)f;
        }
        return out;
    }

    protected static int toDigit(CharSequence data, int index) {
        char ch = data.charAt(index);
        int digit = Character.digit(ch, 16);
        if (digit == -1) {
            throw new IllegalArgumentException("Illegal hexadecimal character " + ch + " at index " + index);
        }
        return digit;
    }
}

