/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.examples.stress.ApplicationException;
import org.apache.commons.rng.examples.stress.LogUtils;
import org.apache.commons.rng.examples.stress.OutputCommand;
import org.apache.commons.rng.examples.stress.ProcessUtils;
import org.apache.commons.rng.examples.stress.RNGUtils;
import org.apache.commons.rng.examples.stress.RngDataOutput;
import org.apache.commons.rng.examples.stress.StandardOptions;
import picocli.CommandLine;

@CommandLine.Command(name="bridge", description={"Transfer test 32-bit data to a test application sub-process via standard input."})
class BridgeTestCommand
implements Callable<Void> {
    @CommandLine.Mixin
    private StandardOptions reusableOptions;
    @CommandLine.Parameters(index="0", description={"The stress test executable."})
    private File executable;
    @CommandLine.Parameters(index="1..*", description={"The arguments to pass to the executable."}, paramLabel="<argument>")
    private List<String> executableArguments = new ArrayList<String>();
    @CommandLine.Option(names={"--prefix"}, description={"Results file prefix (default: ${DEFAULT-VALUE})."})
    private File fileOutputPrefix = new File("bridge");
    @CommandLine.Option(names={"-b", "--byte-order"}, description={"Byte-order of the transferred data (default: ${DEFAULT-VALUE}).", "Valid values: BIG_ENDIAN, LITTLE_ENDIAN."})
    private ByteOrder byteOrder = ByteOrder.nativeOrder();

    BridgeTestCommand() {
    }

    @Override
    public Void call() {
        LogUtils.setLogLevel(this.reusableOptions.logLevel);
        ProcessUtils.checkExecutable(this.executable);
        ProcessUtils.checkOutputDirectory(this.fileOutputPrefix);
        this.runBridgeTest();
        return null;
    }

    private void runBridgeTest() {
        List<String> command = ProcessUtils.buildSubProcessCommand(this.executable, this.executableArguments);
        try {
            File dataFile = new File(this.fileOutputPrefix + ".data");
            File outputFile = new File(this.fileOutputPrefix + ".out");
            File errorFile = new File(this.fileOutputPrefix + ".err");
            final IntBuffer buffer = IntBuffer.allocate(64);
            try (BufferedWriter textOutput = Files.newBufferedWriter(dataFile.toPath(), new OpenOption[0]);){
                int value = 1;
                for (int i = 0; i < 32; ++i) {
                    BridgeTestCommand.writeInt(textOutput, buffer, value);
                    value <<= 1;
                }
                while (buffer.remaining() != 0) {
                    BridgeTestCommand.writeInt(textOutput, buffer, ThreadLocalRandom.current().nextInt());
                }
            }
            buffer.flip();
            IntProvider rng = new IntProvider(){

                public int next() {
                    return buffer.get();
                }
            };
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectOutput(ProcessBuilder.Redirect.to(outputFile));
            builder.redirectError(ProcessBuilder.Redirect.to(errorFile));
            Process testingProcess = builder.start();
            boolean raw64 = false;
            try (RngDataOutput sink = RNGUtils.createDataOutput((UniformRandomProvider)rng, false, testingProcess.getOutputStream(), buffer.capacity() * 4, this.byteOrder);){
                sink.write((UniformRandomProvider)rng);
            }
            Integer exitValue = ProcessUtils.getExitValue(testingProcess);
            if (exitValue == null) {
                LogUtils.error("%s did not exit. Process was killed.", command.get(0));
            } else if (exitValue != 0) {
                LogUtils.error("%s exit code = %d", command.get(0), (int)exitValue);
            }
        }
        catch (IOException ex) {
            throw new ApplicationException("Failed to run process: " + ex.getMessage(), ex);
        }
    }

    private static void writeInt(Writer textOutput, IntBuffer buffer, int value) throws IOException {
        OutputCommand.writeInt(textOutput, value);
        buffer.put(value);
    }
}

