/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.stress;

import java.io.Serializable;
import java.util.Comparator;

class AlphaNumericComparator
implements Comparator<CharSequence>,
Serializable {
    public static final AlphaNumericComparator INSTANCE = new AlphaNumericComparator();
    private static final long serialVersionUID = 1L;

    AlphaNumericComparator() {
    }

    @Override
    public int compare(CharSequence seq1, CharSequence seq2) {
        if (seq1 == seq2) {
            return 0;
        }
        if (seq1 == null) {
            return -1;
        }
        if (seq2 == null) {
            return 1;
        }
        int pos1 = 0;
        int pos2 = 0;
        int length1 = seq1.length();
        int length2 = seq2.length();
        while (pos1 < length1 && pos2 < length2) {
            int end1 = AlphaNumericComparator.nextSubSequenceEnd(seq1, pos1, length1);
            int end2 = AlphaNumericComparator.nextSubSequenceEnd(seq2, pos2, length2);
            int result = 0;
            result = AlphaNumericComparator.isDigit(seq1.charAt(pos1)) && AlphaNumericComparator.isDigit(seq2.charAt(pos2)) ? AlphaNumericComparator.compareNumerically(seq1, pos1, end1, seq2, pos2, end2) : AlphaNumericComparator.compareLexicographically(seq1, pos1, end1, seq2, pos2, end2);
            if (result != 0) {
                return result;
            }
            pos1 = end1;
            pos2 = end2;
        }
        return length1 - length2;
    }

    private static int nextSubSequenceEnd(CharSequence seq, int start, int length) {
        int pos = start;
        boolean seqType = AlphaNumericComparator.isDigit(seq.charAt(pos++));
        while (pos < length && seqType == AlphaNumericComparator.isDigit(seq.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private static boolean isDigit(char ch) {
        return ch >= '0' && ch <= '9';
    }

    private static int compareNumerically(CharSequence seq1, int start1, int end1, CharSequence seq2, int start2, int end2) {
        int pos2;
        int pos1 = AlphaNumericComparator.advancePastLeadingZeros(seq1, start1, end1);
        int result = end1 - pos1 - (end2 - (pos2 = AlphaNumericComparator.advancePastLeadingZeros(seq2, start2, end2)));
        if (result == 0) {
            while (pos1 < end1) {
                char c2;
                char c1;
                if ((c1 = seq1.charAt(pos1++)) == (c2 = seq2.charAt(pos2++))) continue;
                return c1 - c2;
            }
        }
        return result;
    }

    private static int advancePastLeadingZeros(CharSequence seq, int start, int end) {
        int pos;
        for (pos = start; pos < end - 1 && seq.charAt(pos) == '0'; ++pos) {
        }
        return pos;
    }

    private static int compareLexicographically(CharSequence seq1, int start1, int end1, CharSequence seq2, int start2, int end2) {
        int len1 = end1 - start1;
        int len2 = end2 - start2;
        int limit = Math.min(len1, len2);
        for (int i = 0; i < limit; ++i) {
            char c2;
            char c1 = seq1.charAt(i + start1);
            if (c1 == (c2 = seq2.charAt(i + start2))) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }
}

