/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jpms.lib;

import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.GaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;

public class DiceGame {
    private final UniformRandomProvider rng;
    private final ContinuousSampler sampler;
    private final int rounds;
    private int players;

    public DiceGame(int players, int rounds, UniformRandomProvider rng, double mu, double sigma) {
        this.rng = rng;
        this.rounds = rounds;
        this.players = players;
        this.sampler = GaussianSampler.of((NormalizedGaussianSampler)ZigguratNormalizedGaussianSampler.of((UniformRandomProvider)rng), (double)mu, (double)sigma);
    }

    public int[] play() {
        int[] scores = new int[this.players];
        for (int i = 0; i < this.rounds; ++i) {
            this.doRound(scores);
        }
        return scores;
    }

    private void doRound(int[] currentScores) {
        int i = 0;
        while (i < this.players) {
            int n = i++;
            currentScores[n] = currentScores[n] + this.roll();
        }
    }

    private int roll() {
        int score = 0;
        int n = this.numberOfDice();
        for (int i = 0; i < n; ++i) {
            score += this.singleRoll();
        }
        return score;
    }

    private int singleRoll() {
        return this.rng.nextInt(6);
    }

    private int numberOfDice() {
        double n = Math.round(this.sampler.sample());
        return n <= 0.0 ? 0 : (int)n;
    }
}

