/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.simple;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.simple.RandomSource;
import org.apache.commons.rng.simple.ThreadLocalRandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class ThreadLocalPerformance {
    @Param(value={"0", "1", "10", "100"})
    private int numValues;

    @Benchmark
    @Threads(value=4)
    public long threadLocalRandom() {
        ThreadLocalRandom rng = ThreadLocalRandom.current();
        long result = 0L;
        for (int i = 0; i < this.numValues; ++i) {
            result ^= rng.nextLong();
        }
        return result;
    }

    @Benchmark
    @Threads(value=4)
    public long threadLocalRandomWrapped() {
        final ThreadLocalRandom rand = ThreadLocalRandom.current();
        UniformRandomProvider rng = new UniformRandomProvider(){

            public void nextBytes(byte[] bytes) {
            }

            public void nextBytes(byte[] bytes, int start, int len) {
            }

            public int nextInt() {
                return rand.nextInt();
            }

            public int nextInt(int n) {
                return rand.nextInt(n);
            }

            public long nextLong() {
                return rand.nextLong();
            }

            public long nextLong(long n) {
                return rand.nextLong(n);
            }

            public boolean nextBoolean() {
                return rand.nextBoolean();
            }

            public float nextFloat() {
                return rand.nextFloat();
            }

            public double nextDouble() {
                return rand.nextDouble();
            }
        };
        long result = 0L;
        for (int i = 0; i < this.numValues; ++i) {
            result ^= rng.nextLong();
        }
        return result;
    }

    @Benchmark
    @Threads(value=4)
    public long randomSourceCreate(Sources sources) {
        RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)sources.getRandomSource());
        long result = 0L;
        for (int i = 0; i < this.numValues; ++i) {
            result ^= rng.nextLong();
        }
        return result;
    }

    @Benchmark
    @Threads(value=4)
    public long threadLocalRandomSourceCurrent(Sources sources) {
        UniformRandomProvider rng = ThreadLocalRandomSource.current((RandomSource)sources.getRandomSource());
        long result = 0L;
        for (int i = 0; i < this.numValues; ++i) {
            result ^= rng.nextLong();
        }
        return result;
    }

    @Benchmark
    @Threads(value=4)
    public long threadLocalUniformRandomProvider(LocalSources localSources) {
        UniformRandomProvider rng = localSources.getRNG();
        long result = 0L;
        for (int i = 0; i < this.numValues; ++i) {
            result ^= rng.nextLong();
        }
        return result;
    }

    @State(value=Scope.Benchmark)
    public static class LocalSources
    extends Sources {
        private ThreadLocal<UniformRandomProvider> rng;

        public UniformRandomProvider getRNG() {
            return this.rng.get();
        }

        @Override
        @Setup
        public void setup() {
            super.setup();
            this.rng = new ThreadLocal<UniformRandomProvider>(){

                @Override
                protected UniformRandomProvider initialValue() {
                    return RandomSource.create((RandomSource)LocalSources.this.randomSource);
                }
            };
        }
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        protected RandomSource randomSource;
        @Param(value={"SPLIT_MIX_64"})
        private String randomSourceName;

        public RandomSource getRandomSource() {
            return this.randomSource;
        }

        @Setup
        public void setup() {
            this.randomSource = RandomSource.valueOf((String)this.randomSourceName);
        }
    }
}

