/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.simple;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.RestorableUniformRandomProvider;
import org.apache.commons.rng.core.source32.ISAACRandom;
import org.apache.commons.rng.core.source32.JDKRandom;
import org.apache.commons.rng.core.source32.KISSRandom;
import org.apache.commons.rng.core.source32.MersenneTwister;
import org.apache.commons.rng.core.source32.MultiplyWithCarry256;
import org.apache.commons.rng.core.source32.Well1024a;
import org.apache.commons.rng.core.source32.Well19937a;
import org.apache.commons.rng.core.source32.Well19937c;
import org.apache.commons.rng.core.source32.Well44497a;
import org.apache.commons.rng.core.source32.Well44497b;
import org.apache.commons.rng.core.source32.Well512a;
import org.apache.commons.rng.core.source32.XoRoShiRo64Star;
import org.apache.commons.rng.core.source32.XoRoShiRo64StarStar;
import org.apache.commons.rng.core.source32.XoShiRo128Plus;
import org.apache.commons.rng.core.source32.XoShiRo128StarStar;
import org.apache.commons.rng.core.source64.MersenneTwister64;
import org.apache.commons.rng.core.source64.SplitMix64;
import org.apache.commons.rng.core.source64.TwoCmres;
import org.apache.commons.rng.core.source64.XoRoShiRo128Plus;
import org.apache.commons.rng.core.source64.XoRoShiRo128StarStar;
import org.apache.commons.rng.core.source64.XoShiRo256Plus;
import org.apache.commons.rng.core.source64.XoShiRo256StarStar;
import org.apache.commons.rng.core.source64.XoShiRo512Plus;
import org.apache.commons.rng.core.source64.XoShiRo512StarStar;
import org.apache.commons.rng.core.source64.XorShift1024Star;
import org.apache.commons.rng.core.source64.XorShift1024StarPhi;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.examples.jmh.RandomSourceValues;
import org.apache.commons.rng.simple.RandomSource;
import org.apache.commons.rng.simple.internal.ProviderBuilder;
import org.apache.commons.rng.simple.internal.SeedFactory;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms512M", "-Xmx512M"})
public class ConstructionPerformance {
    private static final int SEEDS = 500;
    private static final int MAX_SEED_SIZE = 1391;
    private static final Long[] LONG_SEEDS = new Long[500];
    private static final Integer[] INTEGER_SEEDS = new Integer[500];
    private static final long[][] LONG_ARRAY_SEEDS = new long[500][];
    private static final int[][] INT_ARRAY_SEEDS = new int[500][];
    private static final byte[][] BYTE_ARRAY_SEEDS = new byte[500][];
    private Object[] values = new Object[500];

    public ConstructionPerformance() {
        for (int i = 0; i < 500; ++i) {
            this.values[i] = new Object();
        }
    }

    @Benchmark
    public void baselineConsumeObject(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume(this.values[i]);
        }
    }

    @Benchmark
    public void newObject(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume(new Object());
        }
    }

    @Benchmark
    public void newJDKRandom(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new JDKRandom(LONG_SEEDS[i]));
        }
    }

    @Benchmark
    public void newWell512a(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new Well512a(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newWell1024a(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new Well1024a(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newWell19937a(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new Well19937a(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newWell19937c(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new Well19937c(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newWell44497a(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new Well44497a(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newWell44497b(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new Well44497b(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newMersenneTwister(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new MersenneTwister(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newISAACRandom(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new ISAACRandom(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newSplitMix64(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new SplitMix64(LONG_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXorShift1024Star(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XorShift1024Star(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newTwoCmres(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new TwoCmres(INTEGER_SEEDS[i]));
        }
    }

    @Benchmark
    public void newMersenneTwister64(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new MersenneTwister64(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newMultiplyWithCarry256(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new MultiplyWithCarry256(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newKISSRandom(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new KISSRandom(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXorShift1024StarPhi(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XorShift1024StarPhi(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoRoShiRo64Star(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoRoShiRo64Star(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoRoShiRo64StarStar(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoRoShiRo64StarStar(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoShiRo128Plus(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoShiRo128Plus(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoShiRo128StarStar(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoShiRo128StarStar(INT_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoRoShiRo128Plus(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoRoShiRo128Plus(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoRoShiRo128StarStar(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoRoShiRo128StarStar(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoShiRo256Plus(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoShiRo256Plus(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoShiRo256StarStar(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoShiRo256StarStar(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoShiRo512Plus(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoShiRo512Plus(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newXoShiRo512StarStar(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)new XoShiRo512StarStar(LONG_ARRAY_SEEDS[i]));
        }
    }

    @Benchmark
    public void newInstance(Sources sources, Blackhole bh) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        Object[] nativeSeeds = sources.getNativeSeeds();
        Constructor<Object> constructor = sources.getConstructor();
        for (int i = 0; i < 500; ++i) {
            bh.consume(constructor.newInstance(nativeSeeds[i]));
        }
    }

    @Benchmark
    public void lookupNewInstance(Sources sources, Blackhole bh) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] nativeSeeds = sources.getNativeSeeds();
        Class<?> implementingClass = sources.getImplementingClass();
        for (int i = 0; i < 500; ++i) {
            bh.consume(implementingClass.getConstructor(nativeSeeds[i].getClass()).newInstance(nativeSeeds[i]));
        }
    }

    @Benchmark
    public void createNullSeed(Sources sources, Blackhole bh) {
        RandomSource randomSource = sources.getRandomSource();
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)RandomSource.create((RandomSource)randomSource, null, (Object[])new Object[0]));
        }
    }

    @Benchmark
    public void createNativeSeed(Sources sources, Blackhole bh) {
        RandomSource randomSource = sources.getRandomSource();
        Object[] nativeSeeds = sources.getNativeSeeds();
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)RandomSource.create((RandomSource)randomSource, (Object)nativeSeeds[i], (Object[])new Object[0]));
        }
    }

    @Benchmark
    public void createSelfSeed(Sources sources, Blackhole bh) {
        RandomSource randomSource = sources.getRandomSource();
        Object[] nativeSeeds1 = sources.getNativeSeeds1();
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)RandomSource.create((RandomSource)randomSource, (Object)nativeSeeds1[i], (Object[])new Object[0]));
        }
    }

    @Benchmark
    public void createLongSeed(Sources sources, Blackhole bh) {
        RandomSource randomSource = sources.getRandomSource();
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)RandomSource.create((RandomSource)randomSource, (Object)LONG_SEEDS[i], (Object[])new Object[0]));
        }
    }

    @Benchmark
    public void createByteArray(Sources sources, Blackhole bh) {
        RandomSource randomSource = sources.getRandomSource();
        byte[][] byteSeeds = sources.getByteSeeds();
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)RandomSource.create((RandomSource)randomSource, (Object)byteSeeds[i], (Object[])new Object[0]));
        }
    }

    @Benchmark
    public void createIntArraySeed(IntSizes sizes, Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)SeedFactory.createIntArray((int)sizes.getSize()));
        }
    }

    @Benchmark
    public void createLongArraySeed(LongSizes sizes, Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)SeedFactory.createLongArray((int)sizes.getSize()));
        }
    }

    @Benchmark
    public void createSingleIntegerSeed(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)SeedFactory.createInt());
        }
    }

    @Benchmark
    public void createSingleLongSeed(Blackhole bh) {
        for (int i = 0; i < 500; ++i) {
            bh.consume((Object)SeedFactory.createLong());
        }
    }

    static {
        RestorableUniformRandomProvider rng = RandomSource.create((RandomSource)RandomSource.XOR_SHIFT_1024_S_PHI);
        for (int i = 0; i < 500; ++i) {
            long[] longArray = new long[1391];
            int[] intArray = new int[1391];
            for (int j = 0; j < 1391; ++j) {
                longArray[j] = rng.nextLong();
                intArray[j] = (int)longArray[j];
            }
            ConstructionPerformance.LONG_SEEDS[i] = longArray[0];
            ConstructionPerformance.INTEGER_SEEDS[i] = intArray[0];
            ConstructionPerformance.LONG_ARRAY_SEEDS[i] = longArray;
            ConstructionPerformance.INT_ARRAY_SEEDS[i] = intArray;
            ConstructionPerformance.BYTE_ARRAY_SEEDS[i] = NumberFactory.makeByteArray((long[])longArray);
        }
    }

    @State(value=Scope.Benchmark)
    public static class LongSizes {
        @Param(value={"2", "4", "8", "16", "128", "312"})
        private int size;

        public int getSize() {
            return this.size;
        }
    }

    @State(value=Scope.Benchmark)
    public static class IntSizes {
        @Param(value={"2", "4", "32", "128", "256", "257", "624", "1391"})
        private int size;

        public int getSize() {
            return this.size;
        }
    }

    @State(value=Scope.Benchmark)
    public static class Sources
    extends RandomSourceValues {
        private Object[] nativeSeeds;
        private Object[] nativeSeeds1;
        private byte[][] byteSeeds;
        private Class<?> implementingClass;
        private Constructor<Object> constructor;

        public Object[] getNativeSeeds() {
            return this.nativeSeeds;
        }

        public Object[] getNativeSeeds1() {
            return this.nativeSeeds1;
        }

        public byte[][] getByteSeeds() {
            return this.byteSeeds;
        }

        public Class<?> getImplementingClass() {
            return this.implementingClass;
        }

        public Constructor<Object> getConstructor() {
            return this.constructor;
        }

        @Override
        @Setup(value=Level.Trial)
        public void setup() {
            super.setup();
            RandomSource randomSource = this.getRandomSource();
            this.nativeSeeds = Sources.findNativeSeeds(randomSource);
            if (this.nativeSeeds[0].getClass().isArray()) {
                this.nativeSeeds1 = new Object[500];
                for (int i = 0; i < 500; ++i) {
                    this.nativeSeeds1[i] = Sources.copy(this.nativeSeeds[i], 1);
                }
            } else {
                this.nativeSeeds1 = this.nativeSeeds;
            }
            this.byteSeeds = new byte[500][];
            int byteSize = Sources.findNativeSeedLength(randomSource) * Sources.findNativeSeedElementByteSize(randomSource);
            for (int i = 0; i < 500; ++i) {
                this.byteSeeds[i] = Arrays.copyOf(BYTE_ARRAY_SEEDS[i], byteSize);
            }
            this.implementingClass = Sources.getRandomSourceInternal(randomSource).getRng();
            try {
                this.constructor = this.implementingClass.getConstructor(this.nativeSeeds[0].getClass());
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException("Failed to find the constructor", ex);
            }
        }

        private static Object copy(Object object, int length) {
            if (object instanceof int[]) {
                return Arrays.copyOf((int[])object, length);
            }
            if (object instanceof long[]) {
                return Arrays.copyOf((long[])object, length);
            }
            throw new AssertionError((Object)"Unknown seed array");
        }

        private static Object[] findNativeSeeds(RandomSource randomSource) {
            switch (randomSource) {
                case TWO_CMRES: 
                case TWO_CMRES_SELECT: {
                    return INTEGER_SEEDS;
                }
                case JDK: 
                case SPLIT_MIX_64: {
                    return LONG_SEEDS;
                }
                case WELL_512_A: 
                case WELL_1024_A: 
                case WELL_19937_A: 
                case WELL_19937_C: 
                case WELL_44497_A: 
                case WELL_44497_B: 
                case MT: 
                case ISAAC: 
                case MWC_256: 
                case KISS: 
                case XO_RO_SHI_RO_64_S: 
                case XO_RO_SHI_RO_64_SS: 
                case XO_SHI_RO_128_PLUS: 
                case XO_SHI_RO_128_SS: {
                    return INT_ARRAY_SEEDS;
                }
                case XOR_SHIFT_1024_S: 
                case XOR_SHIFT_1024_S_PHI: 
                case MT_64: 
                case XO_RO_SHI_RO_128_PLUS: 
                case XO_RO_SHI_RO_128_SS: 
                case XO_SHI_RO_256_PLUS: 
                case XO_SHI_RO_256_SS: 
                case XO_SHI_RO_512_PLUS: 
                case XO_SHI_RO_512_SS: {
                    return LONG_ARRAY_SEEDS;
                }
            }
            throw new AssertionError((Object)"Unknown native seed");
        }

        private static int findNativeSeedLength(RandomSource randomSource) {
            switch (randomSource) {
                case TWO_CMRES: 
                case TWO_CMRES_SELECT: 
                case JDK: 
                case SPLIT_MIX_64: {
                    return 1;
                }
                case WELL_512_A: {
                    return 16;
                }
                case WELL_1024_A: {
                    return 32;
                }
                case WELL_19937_A: 
                case WELL_19937_C: {
                    return 624;
                }
                case WELL_44497_A: 
                case WELL_44497_B: {
                    return 1391;
                }
                case MT: {
                    return 624;
                }
                case ISAAC: {
                    return 256;
                }
                case XOR_SHIFT_1024_S: 
                case XOR_SHIFT_1024_S_PHI: {
                    return 16;
                }
                case MT_64: {
                    return 312;
                }
                case MWC_256: {
                    return 257;
                }
                case KISS: {
                    return 4;
                }
                case XO_RO_SHI_RO_64_S: 
                case XO_RO_SHI_RO_64_SS: {
                    return 2;
                }
                case XO_SHI_RO_128_PLUS: 
                case XO_SHI_RO_128_SS: {
                    return 4;
                }
                case XO_RO_SHI_RO_128_PLUS: 
                case XO_RO_SHI_RO_128_SS: {
                    return 2;
                }
                case XO_SHI_RO_256_PLUS: 
                case XO_SHI_RO_256_SS: {
                    return 4;
                }
                case XO_SHI_RO_512_PLUS: 
                case XO_SHI_RO_512_SS: {
                    return 8;
                }
            }
            throw new AssertionError((Object)"Unknown native seed size");
        }

        private static int findNativeSeedElementByteSize(RandomSource randomSource) {
            switch (randomSource) {
                case TWO_CMRES: 
                case TWO_CMRES_SELECT: 
                case JDK: 
                case WELL_512_A: 
                case WELL_1024_A: 
                case WELL_19937_A: 
                case WELL_19937_C: 
                case WELL_44497_A: 
                case WELL_44497_B: 
                case MT: 
                case ISAAC: 
                case MWC_256: 
                case KISS: 
                case XO_RO_SHI_RO_64_S: 
                case XO_RO_SHI_RO_64_SS: 
                case XO_SHI_RO_128_PLUS: 
                case XO_SHI_RO_128_SS: {
                    return 4;
                }
                case SPLIT_MIX_64: 
                case XOR_SHIFT_1024_S: 
                case XOR_SHIFT_1024_S_PHI: 
                case MT_64: 
                case XO_RO_SHI_RO_128_PLUS: 
                case XO_RO_SHI_RO_128_SS: 
                case XO_SHI_RO_256_PLUS: 
                case XO_SHI_RO_256_SS: 
                case XO_SHI_RO_512_PLUS: 
                case XO_SHI_RO_512_SS: {
                    return 8;
                }
            }
            throw new AssertionError((Object)"Unknown native seed element byte size");
        }

        private static ProviderBuilder.RandomSourceInternal getRandomSourceInternal(RandomSource randomSource) {
            switch (randomSource) {
                case JDK: {
                    return ProviderBuilder.RandomSourceInternal.JDK;
                }
                case WELL_512_A: {
                    return ProviderBuilder.RandomSourceInternal.WELL_512_A;
                }
                case WELL_1024_A: {
                    return ProviderBuilder.RandomSourceInternal.WELL_1024_A;
                }
                case WELL_19937_A: {
                    return ProviderBuilder.RandomSourceInternal.WELL_19937_A;
                }
                case WELL_19937_C: {
                    return ProviderBuilder.RandomSourceInternal.WELL_19937_C;
                }
                case WELL_44497_A: {
                    return ProviderBuilder.RandomSourceInternal.WELL_44497_A;
                }
                case WELL_44497_B: {
                    return ProviderBuilder.RandomSourceInternal.WELL_44497_B;
                }
                case MT: {
                    return ProviderBuilder.RandomSourceInternal.MT;
                }
                case ISAAC: {
                    return ProviderBuilder.RandomSourceInternal.ISAAC;
                }
                case TWO_CMRES: {
                    return ProviderBuilder.RandomSourceInternal.TWO_CMRES;
                }
                case TWO_CMRES_SELECT: {
                    return ProviderBuilder.RandomSourceInternal.TWO_CMRES_SELECT;
                }
                case MWC_256: {
                    return ProviderBuilder.RandomSourceInternal.MWC_256;
                }
                case KISS: {
                    return ProviderBuilder.RandomSourceInternal.KISS;
                }
                case SPLIT_MIX_64: {
                    return ProviderBuilder.RandomSourceInternal.SPLIT_MIX_64;
                }
                case XOR_SHIFT_1024_S: {
                    return ProviderBuilder.RandomSourceInternal.XOR_SHIFT_1024_S;
                }
                case MT_64: {
                    return ProviderBuilder.RandomSourceInternal.MT_64;
                }
                case XOR_SHIFT_1024_S_PHI: {
                    return ProviderBuilder.RandomSourceInternal.XOR_SHIFT_1024_S_PHI;
                }
                case XO_RO_SHI_RO_64_S: {
                    return ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_64_S;
                }
                case XO_RO_SHI_RO_64_SS: {
                    return ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_64_SS;
                }
                case XO_SHI_RO_128_PLUS: {
                    return ProviderBuilder.RandomSourceInternal.XO_SHI_RO_128_PLUS;
                }
                case XO_SHI_RO_128_SS: {
                    return ProviderBuilder.RandomSourceInternal.XO_SHI_RO_128_SS;
                }
                case XO_RO_SHI_RO_128_PLUS: {
                    return ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_128_PLUS;
                }
                case XO_RO_SHI_RO_128_SS: {
                    return ProviderBuilder.RandomSourceInternal.XO_RO_SHI_RO_128_SS;
                }
                case XO_SHI_RO_256_PLUS: {
                    return ProviderBuilder.RandomSourceInternal.XO_SHI_RO_256_PLUS;
                }
                case XO_SHI_RO_256_SS: {
                    return ProviderBuilder.RandomSourceInternal.XO_SHI_RO_256_SS;
                }
                case XO_SHI_RO_512_PLUS: {
                    return ProviderBuilder.RandomSourceInternal.XO_SHI_RO_512_PLUS;
                }
                case XO_SHI_RO_512_SS: {
                    return ProviderBuilder.RandomSourceInternal.XO_SHI_RO_512_SS;
                }
            }
            throw new AssertionError((Object)"Unknown random source internal");
        }
    }
}

