/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.RandomAccess;
import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source32.IntProvider;
import org.apache.commons.rng.sampling.ListSampler;
import org.apache.commons.rng.sampling.PermutationSampler;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class ListShuffleBenchmark {
    private static final long POW_32 = 0x100000000L;
    private static final int RANDOM_ACCESS_SIZE_THRESHOLD = 5;

    private static <T> void shuffleUsingPermutationSampler(UniformRandomProvider rng, List<T> list, int start, boolean towardHead) {
        int len = list.size();
        int[] indices = PermutationSampler.natural((int)len);
        PermutationSampler.shuffle((UniformRandomProvider)rng, (int[])indices, (int)start, (boolean)towardHead);
        ArrayList<T> items = new ArrayList<T>(list);
        for (int i = 0; i < len; ++i) {
            list.set(i, items.get(indices[i]));
        }
    }

    private static <T> void shuffleUsingPermutationSamplerRandomAccess(UniformRandomProvider rng, List<T> list, int start, boolean towardHead) {
        int high;
        int len = list.size();
        int[] indices = PermutationSampler.natural((int)len);
        PermutationSampler.shuffle((UniformRandomProvider)rng, (int[])indices, (int)start, (boolean)towardHead);
        ArrayList<T> items = new ArrayList<T>(list);
        int low = towardHead ? 0 : start;
        int n = high = towardHead ? start + 1 : len;
        if (list instanceof RandomAccess) {
            for (int i = low; i < high; ++i) {
                list.set(i, items.get(indices[i]));
            }
        } else {
            ListIterator<T> it = list.listIterator(low);
            for (int i = low; i < high; ++i) {
                it.next();
                it.set(items.get(indices[i]));
            }
        }
    }

    private static void shuffleDirectRandomAccess(UniformRandomProvider rng, List<?> list) {
        if (list instanceof RandomAccess || list.size() < 5) {
            for (int i = list.size(); i > 1; --i) {
                ListShuffleBenchmark.swap(list, i - 1, rng.nextInt(i));
            }
        } else {
            Object[] array = list.toArray();
            for (int i = array.length; i > 1; --i) {
                ListShuffleBenchmark.swap(array, i - 1, rng.nextInt(i));
            }
            ListIterator<?> it = list.listIterator();
            for (Object value : array) {
                it.next();
                it.set(value);
            }
        }
    }

    private static void shuffleDirect(UniformRandomProvider rng, List<?> list) {
        for (int i = list.size(); i > 1; --i) {
            ListShuffleBenchmark.swap(list, i - 1, rng.nextInt(i));
        }
    }

    private static void shuffleIterator(UniformRandomProvider rng, List<?> list) {
        Object[] array = list.toArray();
        for (int i = array.length; i > 1; --i) {
            ListShuffleBenchmark.swap(array, i - 1, rng.nextInt(i));
        }
        ListIterator<?> it = list.listIterator();
        for (Object value : array) {
            it.next();
            it.set(value);
        }
    }

    private static void shuffleDirectRandomAccessDirectional(UniformRandomProvider rng, List<?> list, int start, boolean towardHead) {
        int size = list.size();
        if (list instanceof RandomAccess || size < 5) {
            if (towardHead) {
                for (int i = start; i > 0; --i) {
                    ListShuffleBenchmark.swap(list, i, rng.nextInt(i + 1));
                }
            } else {
                for (int i = size - 1; i > start; --i) {
                    ListShuffleBenchmark.swap(list, i, start + rng.nextInt(i + 1 - start));
                }
            }
        } else {
            Object[] array = list.toArray();
            if (towardHead) {
                for (int i = start; i > 0; --i) {
                    ListShuffleBenchmark.swap(array, i, rng.nextInt(i + 1));
                }
                ListIterator<?> it = list.listIterator();
                for (int i = 0; i <= start; ++i) {
                    it.next();
                    it.set(array[i]);
                }
            } else {
                for (int i = size - 1; i > start; --i) {
                    ListShuffleBenchmark.swap(array, i, start + rng.nextInt(i + 1 - start));
                }
                ListIterator<?> it = list.listIterator(start);
                for (int i = start; i < array.length; ++i) {
                    it.next();
                    it.set(array[i]);
                }
            }
        }
    }

    private static void shuffleDirectRandomAccessSubList(UniformRandomProvider rng, List<?> list, int start, boolean towardHead) {
        if (towardHead) {
            ListShuffleBenchmark.shuffleDirectRandomAccess(rng, list.subList(0, start + 1));
        } else {
            ListShuffleBenchmark.shuffleDirectRandomAccess(rng, list.subList(start, list.size()));
        }
    }

    private static void swap(List<?> list, int i, int j) {
        List<?> l = list;
        l.set(i, l.set(j, l.get(i)));
    }

    private static void swap(Object[] array, int i, int j) {
        Object tmp = array[i];
        array[i] = array[j];
        array[j] = tmp;
    }

    @Benchmark
    public int baselineRandom(ShuffleData data) {
        int sum = 0;
        for (int i = data.getSize(); i > 1; --i) {
            sum += (i - 1) * data.getRandom().nextInt(i);
        }
        return sum;
    }

    @Benchmark
    public int baselineRNG(ShuffleData data) {
        int sum = 0;
        for (int i = data.getSize(); i > 1; --i) {
            sum += (i - 1) * data.getRNG().nextInt(i);
        }
        return sum;
    }

    @Benchmark
    public int baselineRNG2(ShuffleData data) {
        int sum = 0;
        for (int i = data.getSize(); i > 1; --i) {
            sum += data.getRNG().nextInt(i) * (i - 1);
        }
        return sum;
    }

    @Benchmark
    public int baselineRNG3(ShuffleData data) {
        int sum = 0;
        for (int i = data.getSize() - 1; i > 0; --i) {
            sum += i * data.getRNG().nextInt(i + 1);
        }
        return sum;
    }

    @Benchmark
    public Object usingCollections(ListData data) {
        Collections.shuffle(data.getList(), data.getRandom());
        return data.getList();
    }

    @Benchmark
    public Object usingPermutationSampler(ListData data) {
        ListShuffleBenchmark.shuffleUsingPermutationSampler(data.getRNG(), data.getList(), data.getSize() - 1, true);
        return data.getList();
    }

    @Benchmark
    public Object usingPermutationSamplerBidirectional(ListData data) {
        int start = data.getSize() / 2;
        ListShuffleBenchmark.shuffleUsingPermutationSampler(data.getRNG(), data.getList(), start, true);
        ListShuffleBenchmark.shuffleUsingPermutationSampler(data.getRNG(), data.getList(), start + 1, false);
        return data.getList();
    }

    @Benchmark
    public Object usingPermutationSamplerRandomAccess(ListData data) {
        ListShuffleBenchmark.shuffleUsingPermutationSamplerRandomAccess(data.getRNG(), data.getList(), data.getSize() - 1, true);
        return data.getList();
    }

    @Benchmark
    public Object usingPermutationSamplerRandomAccessBidirectional(ListData data) {
        int start = data.getSize() / 2;
        ListShuffleBenchmark.shuffleUsingPermutationSamplerRandomAccess(data.getRNG(), data.getList(), start, true);
        ListShuffleBenchmark.shuffleUsingPermutationSamplerRandomAccess(data.getRNG(), data.getList(), start + 1, false);
        return data.getList();
    }

    @Benchmark
    public Object usingDirectRandomAccess(ListData data) {
        ListShuffleBenchmark.shuffleDirectRandomAccess(data.getRNG(), data.getList());
        return data.getList();
    }

    @Benchmark
    public Object usingDirectRandomAccessDirectionalBidirectional(ListData data) {
        int start = data.getSize() / 2;
        ListShuffleBenchmark.shuffleDirectRandomAccessDirectional(data.getRNG(), data.getList(), start, true);
        ListShuffleBenchmark.shuffleDirectRandomAccessDirectional(data.getRNG(), data.getList(), start + 1, false);
        return data.getList();
    }

    @Benchmark
    public Object usingDirectRandomAccessSublistBidirectional(ListData data) {
        int start = data.getSize() / 2;
        ListShuffleBenchmark.shuffleDirectRandomAccessSubList(data.getRNG(), data.getList(), start, true);
        ListShuffleBenchmark.shuffleDirectRandomAccessSubList(data.getRNG(), data.getList(), start + 1, false);
        return data.getList();
    }

    @Benchmark
    public Object usingListSampler(ListData data) {
        ListSampler.shuffle((UniformRandomProvider)data.getRNG(), data.getList());
        return data.getList();
    }

    @Benchmark
    public Object usingListSamplerBidirectional(ListData data) {
        int start = data.getSize() / 2;
        ListSampler.shuffle((UniformRandomProvider)data.getRNG(), data.getList(), (int)start, (boolean)true);
        ListSampler.shuffle((UniformRandomProvider)data.getRNG(), data.getList(), (int)(start + 1), (boolean)false);
        return data.getList();
    }

    @Benchmark
    public Object shuffleDirect(LinkedListData data) {
        ListShuffleBenchmark.shuffleDirect(data.getRNG(), data.getList());
        return data.getList();
    }

    @Benchmark
    public Object shuffleIterator(LinkedListData data) {
        ListShuffleBenchmark.shuffleIterator(data.getRNG(), data.getList());
        return data.getList();
    }

    static final class SplitMix32Random
    extends Random {
        private static final long serialVersionUID = 1L;
        private long state;

        SplitMix32Random(long seed) {
            this.state = seed;
        }

        private int next() {
            long key = this.state += -7046029254386353131L;
            key = (key ^ key >>> 33) * 7109453100751455733L;
            return (int)((key ^ key >>> 28) * -3808689974395783757L >>> 32);
        }

        @Override
        public int nextInt(int n) {
            long m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
            long l = m & 0xFFFFFFFFL;
            if (l < (long)n) {
                long t = 0x100000000L % (long)n;
                while (l < t) {
                    m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
                    l = m & 0xFFFFFFFFL;
                }
            }
            return (int)(m >>> 32);
        }

        @Override
        protected int next(int n) {
            return this.next() >>> 32 - n;
        }
    }

    static final class SplitMix32RNG
    extends IntProvider {
        private long state;

        SplitMix32RNG(long seed) {
            this.state = seed;
        }

        public int next() {
            long key = this.state += -7046029254386353131L;
            key = (key ^ key >>> 33) * 7109453100751455733L;
            return (int)((key ^ key >>> 28) * -3808689974395783757L >>> 32);
        }

        public int nextInt(int n) {
            long m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
            long l = m & 0xFFFFFFFFL;
            if (l < (long)n) {
                long t = 0x100000000L % (long)n;
                while (l < t) {
                    m = ((long)this.next() & 0xFFFFFFFFL) * (long)n;
                    l = m & 0xFFFFFFFFL;
                }
            }
            return (int)(m >>> 32);
        }
    }

    @State(value=Scope.Benchmark)
    public static class LinkedListData {
        @Param(value={"3", "4", "5", "6", "7", "8"})
        private int size;
        private UniformRandomProvider rng;
        private List<Integer> list;

        public UniformRandomProvider getRNG() {
            return this.rng;
        }

        public List<Integer> getList() {
            return this.list;
        }

        @Setup
        public void setup() {
            this.rng = new SplitMix32RNG(System.currentTimeMillis());
            this.list = new LinkedList<Integer>();
            for (int i = 0; i < this.size; ++i) {
                this.list.add(i);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class ListData
    extends ShuffleData {
        @Param(value={"Array", "Linked"})
        private String type;
        private List<Integer> list;

        public List<Integer> getList() {
            return this.list;
        }

        @Setup
        public void setupList() {
            if ("Array".equals(this.type)) {
                this.list = new ArrayList<Integer>();
            } else if ("Linked".equals(this.type)) {
                this.list = new LinkedList<Integer>();
            }
            for (int i = 0; i < this.getSize(); ++i) {
                this.list.add(i);
            }
        }
    }

    @State(value=Scope.Benchmark)
    public static class ShuffleData {
        @Param(value={"10", "100", "1000", "10000"})
        private int size;
        private UniformRandomProvider rng;
        private Random random;

        public int getSize() {
            return this.size;
        }

        public UniformRandomProvider getRNG() {
            return this.rng;
        }

        public Random getRandom() {
            return this.random;
        }

        @Setup
        public void setupGenerators() {
            long seed = System.currentTimeMillis();
            this.rng = new SplitMix32RNG(seed);
            this.random = new SplitMix32Random(seed);
        }
    }
}

