/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.core;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.examples.jmh.core.BaselineUtils;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class BaselineGenerationPerformance {
    static final int NEXT_BYTES_SIZE = 127;
    static final int NEXT_INT_LIMIT = 2147483629;
    static final long NEXT_LONG_LIMIT = 0x7FFFFFFFFFFFFFE7L;
    private UniformRandomProvider nextBytesProvider = BaselineUtils.getNextBytes();
    private UniformRandomProvider nextIntProvider = BaselineUtils.getNextInt();
    private UniformRandomProvider nextLongProvider = BaselineUtils.getNextLong();
    private UniformRandomProvider nextBooleanProvider = BaselineUtils.getNextBoolean();
    private UniformRandomProvider nextFloatProvider = BaselineUtils.getNextFloat();
    private UniformRandomProvider nextDoubleProvider = BaselineUtils.getNextDouble();
    @Param(value={"50000", "100000", "150000", "200000", "250000"})
    private int numValues;

    @Benchmark
    public void nextBytes(Blackhole bh) {
        byte[] result = new byte[127];
        for (int i = this.numValues; i > 0; --i) {
            this.nextBytesProvider.nextBytes(result);
            bh.consume((Object)result);
        }
    }

    @Benchmark
    public void nextInt(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextIntProvider.nextInt());
        }
    }

    @Benchmark
    public void nextIntN(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextIntProvider.nextInt(2147483629));
        }
    }

    @Benchmark
    public void nextLong(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextLongProvider.nextLong());
        }
    }

    @Benchmark
    public void nextLongN(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextLongProvider.nextLong(0x7FFFFFFFFFFFFFE7L));
        }
    }

    @Benchmark
    public void nextBoolean(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextBooleanProvider.nextBoolean());
        }
    }

    @Benchmark
    public void nextFloat(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextFloatProvider.nextFloat());
        }
    }

    @Benchmark
    public void nextDouble(Blackhole bh) {
        for (int i = this.numValues; i > 0; --i) {
            bh.consume(this.nextDoubleProvider.nextDouble());
        }
    }
}

