/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.examples.jmh.distribution;

import java.util.concurrent.TimeUnit;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.distribution.AhrensDieterExponentialSampler;
import org.apache.commons.rng.sampling.distribution.AhrensDieterMarsagliaTsangGammaSampler;
import org.apache.commons.rng.sampling.distribution.BoxMullerNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.ChengBetaSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousUniformSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.rng.sampling.distribution.LogNormalSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaNormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.NormalizedGaussianSampler;
import org.apache.commons.rng.sampling.distribution.PoissonSampler;
import org.apache.commons.rng.sampling.distribution.RejectionInversionZipfSampler;
import org.apache.commons.rng.sampling.distribution.ZigguratNormalizedGaussianSampler;
import org.apache.commons.rng.simple.RandomSource;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
@Fork(value=1, jvmArgs={"-server", "-Xms128M", "-Xmx128M"})
public class SamplersPerformance {
    private static final int NUM_SAMPLES = 10000000;

    private void runSample(ContinuousSampler sampler, Blackhole bh) {
        for (int i = 0; i < 10000000; ++i) {
            bh.consume(sampler.sample());
        }
    }

    private void runSample(DiscreteSampler sampler, Blackhole bh) {
        for (int i = 0; i < 10000000; ++i) {
            bh.consume(sampler.sample());
        }
    }

    @Benchmark
    public void runBoxMullerNormalizedGaussianSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new BoxMullerNormalizedGaussianSampler(sources.getGenerator()), bh);
    }

    @Benchmark
    public void runMarsagliaNormalizedGaussianSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new MarsagliaNormalizedGaussianSampler(sources.getGenerator()), bh);
    }

    @Benchmark
    public void runZigguratNormalizedGaussianSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new ZigguratNormalizedGaussianSampler(sources.getGenerator()), bh);
    }

    @Benchmark
    public void runAhrensDieterExponentialSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new AhrensDieterExponentialSampler(sources.getGenerator(), 4.56), bh);
    }

    @Benchmark
    public void runAhrensDieterMarsagliaTsangGammaSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new AhrensDieterMarsagliaTsangGammaSampler(sources.getGenerator(), 9.8, 0.76), bh);
    }

    @Benchmark
    public void runBoxMullerLogNormalSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new LogNormalSampler((NormalizedGaussianSampler)new BoxMullerNormalizedGaussianSampler(sources.getGenerator()), 12.3, 4.6), bh);
    }

    @Benchmark
    public void runMarsagliaLogNormalSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new LogNormalSampler((NormalizedGaussianSampler)new MarsagliaNormalizedGaussianSampler(sources.getGenerator()), 12.3, 4.6), bh);
    }

    @Benchmark
    public void runZigguratLogNormalSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new LogNormalSampler((NormalizedGaussianSampler)new ZigguratNormalizedGaussianSampler(sources.getGenerator()), 12.3, 4.6), bh);
    }

    @Benchmark
    public void runChengBetaSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new ChengBetaSampler(sources.getGenerator(), 0.45, 6.7), bh);
    }

    @Benchmark
    public void runContinuousUniformSampler(Sources sources, Blackhole bh) {
        this.runSample((ContinuousSampler)new ContinuousUniformSampler(sources.getGenerator(), 123.4, 5678.9), bh);
    }

    @Benchmark
    public void runDiscreteUniformSampler(Sources sources, Blackhole bh) {
        this.runSample((DiscreteSampler)new DiscreteUniformSampler(sources.getGenerator(), -98, 76), bh);
    }

    @Benchmark
    public void runRejectionInversionZipfSampler(Sources sources, Blackhole bh) {
        this.runSample((DiscreteSampler)new RejectionInversionZipfSampler(sources.getGenerator(), 43, 2.1), bh);
    }

    @Benchmark
    public void runPoissonSampler(Sources sources, Blackhole bh) {
        this.runSample((DiscreteSampler)new PoissonSampler(sources.getGenerator(), 8.9), bh);
    }

    @State(value=Scope.Benchmark)
    public static class Sources {
        @Param(value={"JDK", "WELL_512_A", "WELL_1024_A", "WELL_19937_A", "WELL_19937_C", "WELL_44497_A", "WELL_44497_B", "MT", "ISAAC", "SPLIT_MIX_64", "MWC_256", "KISS", "XOR_SHIFT_1024_S", "TWO_CMRES", "MT_64"})
        private String randomSourceName;
        private UniformRandomProvider generator;

        public UniformRandomProvider getGenerator() {
            return this.generator;
        }

        @Setup
        public void setup() {
            RandomSource randomSource = RandomSource.valueOf((String)this.randomSourceName);
            this.generator = RandomSource.create((RandomSource)randomSource);
        }
    }
}

