/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.util;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.proxy.factory.util.ProxyClassGenerator;

public class ProxyClassCache {
    private final Map loaderToClassCache = new WeakHashMap();
    private final ProxyClassGenerator proxyClassGenerator;

    public ProxyClassCache(ProxyClassGenerator proxyClassGenerator) {
        this.proxyClassGenerator = proxyClassGenerator;
    }

    private Map getClassCache(ClassLoader classLoader) {
        HashMap cache = (HashMap)this.loaderToClassCache.get(classLoader);
        if (cache == null) {
            cache = new HashMap();
            this.loaderToClassCache.put(classLoader, cache);
        }
        return cache;
    }

    private String toClassCacheKey(Class[] proxyClasses) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < proxyClasses.length; ++i) {
            Class proxyInterface = proxyClasses[i];
            sb.append(proxyInterface.getName());
            if (i == proxyClasses.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Class getProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
        Class proxyClass;
        String key;
        Map classCache = this.getClassCache(classLoader);
        WeakReference proxyClassReference = (WeakReference)classCache.get(key = this.toClassCacheKey(proxyClasses));
        if (proxyClassReference == null) {
            proxyClass = this.proxyClassGenerator.generateProxyClass(classLoader, proxyClasses);
            classCache.put(key, new WeakReference<Class>(proxyClass));
        } else {
            WeakReference weakReference = proxyClassReference;
            synchronized (weakReference) {
                proxyClass = (Class)proxyClassReference.get();
                if (proxyClass == null) {
                    proxyClass = this.proxyClassGenerator.generateProxyClass(classLoader, proxyClasses);
                    classCache.put(key, new WeakReference<Class>(proxyClass));
                }
            }
        }
        return proxyClass;
    }
}

