/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.javassist;

import [Ljava.lang.Class;;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.exception.ProxyFactoryException;
import org.apache.commons.proxy.factory.javassist.JavassistInvocation;
import org.apache.commons.proxy.factory.javassist.JavassistUtils;
import org.apache.commons.proxy.factory.util.AbstractProxyClassGenerator;
import org.apache.commons.proxy.factory.util.AbstractSubclassingProxyFactory;
import org.apache.commons.proxy.factory.util.ProxyClassCache;

public class JavassistProxyFactory
extends AbstractSubclassingProxyFactory {
    private static final String GET_METHOD_METHOD_NAME = "_javassistGetMethod";
    private static final ProxyClassCache delegatingProxyClassCache = new ProxyClassCache(new DelegatingProxyClassGenerator());
    private static final ProxyClassCache interceptorProxyClassCache = new ProxyClassCache(new InterceptorProxyClassGenerator());
    private static final ProxyClassCache invocationHandlerProxyClassCache = new ProxyClassCache(new InvokerProxyClassGenerator());

    private static void addGetMethodMethod(CtClass proxyClass) throws CannotCompileException {
        CtMethod method = new CtMethod(JavassistUtils.resolve(Method.class), GET_METHOD_METHOD_NAME, JavassistUtils.resolve(new Class[]{String.class, String.class, Class;.class}), proxyClass);
        String body = "try { return Class.forName($1).getMethod($2, $3); } catch( Exception e ) { throw new RuntimeException(\"Unable to look up method.\", e); }";
        method.setBody("try { return Class.forName($1).getMethod($2, $3); } catch( Exception e ) { throw new RuntimeException(\"Unable to look up method.\", e); }");
        proxyClass.addMethod(method);
    }

    public Object createDelegatorProxy(ClassLoader classLoader, ObjectProvider targetProvider, Class[] proxyClasses) {
        try {
            Class clazz = delegatingProxyClassCache.getProxyClass(classLoader, proxyClasses);
            return clazz.getConstructor(ObjectProvider.class).newInstance(targetProvider);
        }
        catch (Exception e) {
            throw new ProxyFactoryException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        try {
            Class clazz = interceptorProxyClassCache.getProxyClass(classLoader, proxyClasses);
            return clazz.getConstructor(Object.class, Interceptor.class).newInstance(target, interceptor);
        }
        catch (Exception e) {
            throw new ProxyFactoryException("Unable to instantiate proxy class instance.", e);
        }
    }

    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        try {
            Class clazz = invocationHandlerProxyClassCache.getProxyClass(classLoader, proxyClasses);
            return clazz.getConstructor(Invoker.class).newInstance(invoker);
        }
        catch (Exception e) {
            throw new ProxyFactoryException("Unable to instantiate proxy from generated proxy class.", e);
        }
    }

    private static void addEqualsMethod(CtClass proxyClass) throws CannotCompileException {
        CtMethod equalsMethod = new CtMethod(JavassistUtils.resolve(Boolean.TYPE), "equals", JavassistUtils.resolve(new Class[]{Object.class}), proxyClass);
        String body = "{\n\treturn this == $1;\n}";
        equalsMethod.setBody("{\n\treturn this == $1;\n}");
        proxyClass.addMethod(equalsMethod);
    }

    private static void addHashCodeMethod(CtClass proxyClass) throws CannotCompileException {
        CtMethod hashCodeMethod = new CtMethod(JavassistUtils.resolve(Integer.TYPE), "hashCode", new CtClass[0], proxyClass);
        hashCodeMethod.setBody("{\n\treturn System.identityHashCode(this);\n}");
        proxyClass.addMethod(hashCodeMethod);
    }

    private static class InvokerProxyClassGenerator
    extends AbstractProxyClassGenerator {
        private InvokerProxyClassGenerator() {
        }

        public Class generateProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractSubclassingProxyFactory.getSuperclass(proxyClasses));
                Method[] methods = InvokerProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistUtils.addInterfaces(proxyClass, JavassistProxyFactory.toInterfaces(proxyClasses));
                JavassistUtils.addField(class$org$apache$commons$proxy$Invoker == null ? (class$org$apache$commons$proxy$Invoker = JavassistProxyFactory.class$("org.apache.commons.proxy.Invoker")) : class$org$apache$commons$proxy$Invoker, "invoker", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{class$org$apache$commons$proxy$Invoker == null ? (class$org$apache$commons$proxy$Invoker = JavassistProxyFactory.class$("org.apache.commons.proxy.Invoker")) : class$org$apache$commons$proxy$Invoker}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.invoker = $1; }");
                proxyClass.addConstructor(proxyConstructor);
                JavassistProxyFactory.addGetMethodMethod(proxyClass);
                JavassistProxyFactory.addHashCodeMethod(proxyClass);
                JavassistProxyFactory.addEqualsMethod(proxyClass);
                for (int i = 0; i < methods.length; ++i) {
                    if (JavassistProxyFactory.isEqualsMethod(methods[i]) || JavassistProxyFactory.isHashCode(methods[i])) continue;
                    CtMethod method = new CtMethod(JavassistUtils.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistUtils.resolve(methods[i].getParameterTypes()), proxyClass);
                    String body = "{\n\t return ( $r ) invoker.invoke( this, _javassistGetMethod(\"" + methods[i].getDeclaringClass().getName() + "\", \"" + methods[i].getName() + "\", $sig), $args );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader);
            }
            catch (CannotCompileException e) {
                throw new ProxyFactoryException("Could not compile class.", e);
            }
        }
    }

    private static class InterceptorProxyClassGenerator
    extends AbstractProxyClassGenerator {
        private InterceptorProxyClassGenerator() {
        }

        public Class generateProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractSubclassingProxyFactory.getSuperclass(proxyClasses));
                Method[] methods = InterceptorProxyClassGenerator.getImplementationMethods(proxyClasses);
                JavassistUtils.addInterfaces(proxyClass, JavassistProxyFactory.toInterfaces(proxyClasses));
                JavassistUtils.addField(class$java$lang$Object == null ? (class$java$lang$Object = JavassistProxyFactory.class$("java.lang.Object")) : class$java$lang$Object, "target", proxyClass);
                JavassistUtils.addField(class$org$apache$commons$proxy$Interceptor == null ? (class$org$apache$commons$proxy$Interceptor = JavassistProxyFactory.class$("org.apache.commons.proxy.Interceptor")) : class$org$apache$commons$proxy$Interceptor, "interceptor", proxyClass);
                JavassistProxyFactory.addGetMethodMethod(proxyClass);
                JavassistProxyFactory.addHashCodeMethod(proxyClass);
                JavassistProxyFactory.addEqualsMethod(proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = JavassistProxyFactory.class$("java.lang.Object")) : class$java$lang$Object, class$org$apache$commons$proxy$Interceptor == null ? (class$org$apache$commons$proxy$Interceptor = JavassistProxyFactory.class$("org.apache.commons.proxy.Interceptor")) : class$org$apache$commons$proxy$Interceptor}), proxyClass);
                proxyConstructor.setBody("{\n\tthis.target = $1;\n\tthis.interceptor = $2; }");
                proxyClass.addConstructor(proxyConstructor);
                for (int i = 0; i < methods.length; ++i) {
                    if (JavassistProxyFactory.isEqualsMethod(methods[i]) || JavassistProxyFactory.isHashCode(methods[i])) continue;
                    CtMethod method = new CtMethod(JavassistUtils.resolve(methods[i].getReturnType()), methods[i].getName(), JavassistUtils.resolve(methods[i].getParameterTypes()), proxyClass);
                    Class invocationClass = JavassistInvocation.getMethodInvocationClass(classLoader, methods[i]);
                    String body = "{\n\t return ( $r ) interceptor.intercept( new " + invocationClass.getName() + "( " + JavassistProxyFactory.GET_METHOD_METHOD_NAME + "(\"" + methods[i].getDeclaringClass().getName() + "\", \"" + methods[i].getName() + "\", $sig), target, $args ) );\n }";
                    method.setBody(body);
                    proxyClass.addMethod(method);
                }
                return proxyClass.toClass(classLoader);
            }
            catch (CannotCompileException e) {
                throw new ProxyFactoryException("Could not compile class.", e);
            }
        }
    }

    private static class DelegatingProxyClassGenerator
    extends AbstractProxyClassGenerator {
        private DelegatingProxyClassGenerator() {
        }

        public Class generateProxyClass(ClassLoader classLoader, Class[] proxyClasses) {
            try {
                CtClass proxyClass = JavassistUtils.createClass(AbstractSubclassingProxyFactory.getSuperclass(proxyClasses));
                JavassistUtils.addField(class$org$apache$commons$proxy$ObjectProvider == null ? (class$org$apache$commons$proxy$ObjectProvider = JavassistProxyFactory.class$("org.apache.commons.proxy.ObjectProvider")) : class$org$apache$commons$proxy$ObjectProvider, "provider", proxyClass);
                CtConstructor proxyConstructor = new CtConstructor(JavassistUtils.resolve(new Class[]{class$org$apache$commons$proxy$ObjectProvider == null ? (class$org$apache$commons$proxy$ObjectProvider = JavassistProxyFactory.class$("org.apache.commons.proxy.ObjectProvider")) : class$org$apache$commons$proxy$ObjectProvider}), proxyClass);
                proxyConstructor.setBody("{ this.provider = $1; }");
                proxyClass.addConstructor(proxyConstructor);
                JavassistUtils.addInterfaces(proxyClass, JavassistProxyFactory.toInterfaces(proxyClasses));
                JavassistProxyFactory.addHashCodeMethod(proxyClass);
                JavassistProxyFactory.addEqualsMethod(proxyClass);
                Method[] methods = DelegatingProxyClassGenerator.getImplementationMethods(proxyClasses);
                for (int i = 0; i < methods.length; ++i) {
                    if (JavassistProxyFactory.isEqualsMethod(methods[i]) || JavassistProxyFactory.isHashCode(methods[i])) continue;
                    Method method = methods[i];
                    CtMethod ctMethod = new CtMethod(JavassistUtils.resolve(method.getReturnType()), method.getName(), JavassistUtils.resolve(method.getParameterTypes()), proxyClass);
                    String body = "{ return ( $r ) ( ( " + method.getDeclaringClass().getName() + " )provider.getObject() )." + method.getName() + "($$); }";
                    ctMethod.setBody(body);
                    proxyClass.addMethod(ctMethod);
                }
                return proxyClass.toClass(classLoader);
            }
            catch (CannotCompileException e) {
                throw new ProxyFactoryException("Could not compile class.", e);
            }
        }
    }
}

