/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.proxy.factory.cglib;

import java.io.Serializable;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.InvocationHandler;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.apache.commons.proxy.Interceptor;
import org.apache.commons.proxy.Invocation;
import org.apache.commons.proxy.Invoker;
import org.apache.commons.proxy.ObjectProvider;
import org.apache.commons.proxy.factory.util.AbstractSubclassingProxyFactory;

public class CglibProxyFactory
extends AbstractSubclassingProxyFactory {
    private static CallbackFilter callbackFilter = new CglibProxyFactoryCallbackFilter();

    public Object createDelegatorProxy(ClassLoader classLoader, ObjectProvider targetProvider, Class[] proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces(CglibProxyFactory.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibProxyFactory.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(new Callback[]{new ObjectProviderDispatcher(targetProvider), new EqualsHandler(), new HashCodeHandler()});
        return enhancer.create();
    }

    public Object createInterceptorProxy(ClassLoader classLoader, Object target, Interceptor interceptor, Class[] proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces(CglibProxyFactory.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibProxyFactory.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(new Callback[]{new InterceptorBridge(target, interceptor), new EqualsHandler(), new HashCodeHandler()});
        return enhancer.create();
    }

    public Object createInvokerProxy(ClassLoader classLoader, Invoker invoker, Class[] proxyClasses) {
        Enhancer enhancer = new Enhancer();
        enhancer.setClassLoader(classLoader);
        enhancer.setInterfaces(CglibProxyFactory.toInterfaces(proxyClasses));
        enhancer.setSuperclass(CglibProxyFactory.getSuperclass(proxyClasses));
        enhancer.setCallbackFilter(callbackFilter);
        enhancer.setCallbacks(new Callback[]{new InvokerBridge(invoker), new EqualsHandler(), new HashCodeHandler()});
        return enhancer.create();
    }

    private static class CglibProxyFactoryCallbackFilter
    implements CallbackFilter {
        private CglibProxyFactoryCallbackFilter() {
        }

        public int accept(Method method) {
            if (CglibProxyFactory.isEqualsMethod(method)) {
                return 1;
            }
            if (CglibProxyFactory.isHashCode(method)) {
                return 2;
            }
            return 0;
        }
    }

    private static class ObjectProviderDispatcher
    implements Dispatcher,
    Serializable {
        private final ObjectProvider delegateProvider;

        public ObjectProviderDispatcher(ObjectProvider delegateProvider) {
            this.delegateProvider = delegateProvider;
        }

        public Object loadObject() {
            return this.delegateProvider.getObject();
        }
    }

    private static class MethodProxyInvocation
    implements Invocation,
    Serializable {
        private final MethodProxy methodProxy;
        private final Method method;
        private final Object[] args;
        private final Object target;

        public MethodProxyInvocation(Object target, Method method, Object[] args, MethodProxy methodProxy) {
            this.target = target;
            this.method = method;
            this.methodProxy = methodProxy;
            this.args = args;
        }

        public Method getMethod() {
            return this.method;
        }

        public Object[] getArguments() {
            return this.args;
        }

        public Object proceed() throws Throwable {
            return this.methodProxy.invoke(this.target, this.args);
        }

        public Object getProxy() {
            return this.target;
        }
    }

    private static class InvokerBridge
    implements InvocationHandler,
    Serializable {
        private final Invoker original;

        public InvokerBridge(Invoker original) {
            this.original = original;
        }

        public Object invoke(Object object, Method method, Object[] objects) throws Throwable {
            return this.original.invoke(object, method, objects);
        }
    }

    private static class EqualsHandler
    implements MethodInterceptor,
    Serializable {
        private EqualsHandler() {
        }

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return o == objects[0];
        }
    }

    private static class HashCodeHandler
    implements MethodInterceptor,
    Serializable {
        private HashCodeHandler() {
        }

        public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
            return new Integer(System.identityHashCode(o));
        }
    }

    private static class InterceptorBridge
    implements MethodInterceptor,
    Serializable {
        private final Interceptor inner;
        private final Object target;

        public InterceptorBridge(Object target, Interceptor inner) {
            this.inner = inner;
            this.target = target;
        }

        public Object intercept(Object object, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            return this.inner.intercept(new MethodProxyInvocation(this.target, method, args, methodProxy));
        }
    }
}

