/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.validation;

import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.validation.Branches;
import org.apache.commons.pipeline.validation.ConsumedTypes;
import org.apache.commons.pipeline.validation.ProducedTypes;
import org.apache.commons.pipeline.validation.ProductionOnBranch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidationUtils {
    private ValidationUtils() {
    }

    public static final Boolean canSucceed(Stage upstream, Stage downstream) {
        if (upstream.getClass().isAnnotationPresent(ProducedTypes.class) && downstream.getClass().isAnnotationPresent(ConsumedTypes.class)) {
            ProducedTypes p = upstream.getClass().getAnnotation(ProducedTypes.class);
            ConsumedTypes c = downstream.getClass().getAnnotation(ConsumedTypes.class);
            return ValidationUtils.compatible(p.value(), c.value());
        }
        return null;
    }

    public static final Boolean canSucceedOnBranch(Stage upstream, String downstreamBranchKey, Stage downstream) {
        if (downstream.getClass().isAnnotationPresent(ConsumedTypes.class)) {
            ConsumedTypes c = downstream.getClass().getAnnotation(ConsumedTypes.class);
            if (upstream.getClass().isAnnotationPresent(ProductionOnBranch.class)) {
                ProductionOnBranch pob = upstream.getClass().getAnnotation(ProductionOnBranch.class);
                if (!downstreamBranchKey.equals(pob.branchKey())) {
                    return false;
                }
                return ValidationUtils.compatible(pob.producedTypes(), c.value());
            }
            if (upstream.getClass().isAnnotationPresent(Branches.class)) {
                Branches branches = upstream.getClass().getAnnotation(Branches.class);
                for (ProductionOnBranch pob : branches.productionOnBranches()) {
                    if (!downstreamBranchKey.equals(pob.branchKey())) continue;
                    return ValidationUtils.compatible(pob.producedTypes(), c.value());
                }
                return false;
            }
        }
        return null;
    }

    private static Boolean compatible(Class<?>[] producedTypes, Class<?>[] consumedTypes) {
        for (Class<?> consumed : consumedTypes) {
            for (Class<?> produced : producedTypes) {
                if (!consumed.isAssignableFrom(produced)) continue;
                return true;
            }
        }
        return false;
    }
}

