/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.pipeline.Pipeline;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageDriverFactory;
import org.apache.commons.pipeline.validation.Branches;
import org.apache.commons.pipeline.validation.PipelineValidator;
import org.apache.commons.pipeline.validation.ProducedTypes;
import org.apache.commons.pipeline.validation.ProductionOnBranch;
import org.apache.commons.pipeline.validation.ValidationFailure;
import org.apache.commons.pipeline.validation.ValidationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePipelineValidator
implements PipelineValidator {
    @Override
    public List<ValidationFailure> validate(Pipeline pipeline) {
        ArrayList<ValidationFailure> errors = new ArrayList<ValidationFailure>();
        Stage previous = null;
        Iterator<Stage> iter = pipeline.getStages().iterator();
        while (iter.hasNext()) {
            Stage stage = iter.next();
            if (previous != null && !ValidationUtils.canSucceed(previous, stage).booleanValue()) {
                errors.add(new ValidationFailure(ValidationFailure.Type.STAGE_CONNECT, "Stage cannot consume output of prior stage.", previous, stage));
            }
            if (stage.getClass().isAnnotationPresent(ProductionOnBranch.class)) {
                ProductionOnBranch pob = stage.getClass().getAnnotation(ProductionOnBranch.class);
                errors.addAll(this.validateBranchConnect(pipeline, pob.branchKey(), stage));
            } else if (stage.getClass().isAnnotationPresent(Branches.class)) {
                Branches branches = stage.getClass().getAnnotation(Branches.class);
                for (ProductionOnBranch pob : branches.productionOnBranches()) {
                    errors.addAll(this.validateBranchConnect(pipeline, pob.branchKey(), stage));
                }
                if (previous != null) {
                    for (String branchKey : branches.producesConsumedOnBranches()) {
                        errors.addAll(this.validateBranchConnect(pipeline, branchKey, previous));
                    }
                }
            }
            if (!stage.getClass().isAnnotationPresent(ProducedTypes.class)) continue;
            if (stage.getClass().getAnnotation(ProducedTypes.class).value().length == 0) {
                if (!iter.hasNext()) break;
                errors.add(new ValidationFailure(ValidationFailure.Type.STAGE_CONNECT, "Stage with no production is not at terminus of pipeline.", stage, iter.next()));
                break;
            }
            previous = stage;
        }
        for (Pipeline branch : pipeline.getBranches().values()) {
            errors.addAll(this.validate(branch));
        }
        return errors;
    }

    private List<ValidationFailure> validateBranchConnect(Pipeline pipeline, String branchKey, Stage upstreamStage) {
        ArrayList<ValidationFailure> errors = new ArrayList<ValidationFailure>();
        Pipeline branch = pipeline.getBranches().get(branchKey);
        if (branch == null) {
            errors.add(new ValidationFailure(ValidationFailure.Type.BRANCH_NOT_FOUND, "Branch not found for production key " + branchKey, upstreamStage, null));
        } else if (branch.getStages().isEmpty()) {
            errors.add(new ValidationFailure(ValidationFailure.Type.BRANCH_CONNECT, "Branch pipeline for key " + branchKey + " has no stages.", upstreamStage, null));
        } else if (!ValidationUtils.canSucceed(upstreamStage, branch.getStages().get(0)).booleanValue()) {
            errors.add(new ValidationFailure(ValidationFailure.Type.BRANCH_CONNECT, "Branch " + branchKey + " cannot consume data produced by stage.", upstreamStage, branch.getStages().get(0)));
        }
        return errors;
    }

    @Override
    public List<ValidationFailure> validateAddStage(Pipeline pipeline, Stage stage, StageDriverFactory driverFactory) {
        if (pipeline.getStages().isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ValidationFailure> errors = new ArrayList<ValidationFailure>();
        Stage previous = null;
        for (int i = pipeline.getStages().size() - 1; i >= 0; --i) {
            Stage test = pipeline.getStages().get(i);
            if (!test.getClass().isAnnotationPresent(ProducedTypes.class)) continue;
            if (test.getClass().getAnnotation(ProducedTypes.class).value().length == 0) {
                errors.add(new ValidationFailure(ValidationFailure.Type.STAGE_CONNECT, "Attempt to add stage to pipeline with no production at terminus.", test, stage));
                break;
            }
            previous = test;
            break;
        }
        if (previous != null && !ValidationUtils.canSucceed(previous, stage).booleanValue()) {
            errors.add(new ValidationFailure(ValidationFailure.Type.STAGE_CONNECT, "Stage cannot consume output of prior stage.", previous, stage));
        }
        return errors;
    }

    @Override
    public List<ValidationFailure> validateAddBranch(Pipeline pipeline, String branchKey, Pipeline branch) {
        return Collections.emptyList();
    }
}

