/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.util;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface QueueFactory<T> {
    public Queue<T> createQueue();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PriorityQueueFactory<T>
    extends AbstractQueueFactory<T>
    implements QueueFactory<T> {
        private int initialCapacity = 11;
        private Comparator<? super T> comparator;

        @Override
        public PriorityQueue<T> createQueue() {
            if (this.comparator == null) {
                if (this.initialContents == null || this.initialContents.isEmpty()) {
                    return new PriorityQueue(this.initialCapacity);
                }
                return new PriorityQueue(this.initialContents);
            }
            PriorityQueue<T> queue = new PriorityQueue<T>(this.initialCapacity, this.comparator);
            queue.addAll(this.initialContents);
            return queue;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public void setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        public Comparator<? super T> getComparator() {
            return this.comparator;
        }

        public void setComparator(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConcurrentLinkedQueueFactory<T>
    extends AbstractQueueFactory<T>
    implements QueueFactory<T> {
        @Override
        public ConcurrentLinkedQueue<T> createQueue() {
            if (this.initialContents == null || this.initialContents.isEmpty()) {
                return new ConcurrentLinkedQueue();
            }
            return new ConcurrentLinkedQueue(this.initialContents);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedListFactory<T>
    extends AbstractQueueFactory<T>
    implements QueueFactory<T> {
        @Override
        public LinkedList<T> createQueue() {
            if (this.initialContents == null || this.initialContents.isEmpty()) {
                return new LinkedList();
            }
            return new LinkedList(this.initialContents);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AbstractQueueFactory<T> {
        protected Collection<? extends T> initialContents;

        public Collection<? extends T> getInitialContents() {
            return this.initialContents;
        }

        public void setInitialContents(Collection<? extends T> initialContents) {
            this.initialContents = initialContents;
        }
    }
}

