/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.util;

import java.util.Comparator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.commons.pipeline.util.QueueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface BlockingQueueFactory<T>
extends QueueFactory<T> {
    @Override
    public BlockingQueue<T> createQueue();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SynchronousQueueFactory<T>
    implements BlockingQueueFactory<T> {
        private boolean fair = false;

        @Override
        public SynchronousQueue<T> createQueue() {
            return new SynchronousQueue(this.fair);
        }

        public boolean isFair() {
            return this.fair;
        }

        public void setFair(boolean fair) {
            this.fair = fair;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PriorityBlockingQueueFactory<T>
    extends QueueFactory.AbstractQueueFactory<T>
    implements BlockingQueueFactory<T> {
        private int initialCapacity = 11;
        private Comparator<? super T> comparator;

        @Override
        public PriorityBlockingQueue<T> createQueue() {
            if (this.comparator == null) {
                if (this.initialContents == null || this.initialContents.isEmpty()) {
                    return new PriorityBlockingQueue(this.initialCapacity);
                }
                return new PriorityBlockingQueue(this.initialContents);
            }
            PriorityBlockingQueue<T> queue = new PriorityBlockingQueue<T>(this.initialCapacity, this.comparator);
            if (this.initialContents != null && !this.initialContents.isEmpty()) {
                queue.addAll(this.initialContents);
            }
            return queue;
        }

        public int getInitialCapacity() {
            return this.initialCapacity;
        }

        public void setInitialCapacity(int initialCapacity) {
            this.initialCapacity = initialCapacity;
        }

        public Comparator<? super T> getComparator() {
            return this.comparator;
        }

        public void setComparator(Comparator<? super T> comparator) {
            this.comparator = comparator;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LinkedBlockingQueueFactory<T>
    extends QueueFactory.AbstractQueueFactory<T>
    implements BlockingQueueFactory<T> {
        private int capacity = Integer.MAX_VALUE;

        @Override
        public LinkedBlockingQueue<T> createQueue() {
            if (this.initialContents == null || this.initialContents.isEmpty()) {
                return new LinkedBlockingQueue(this.capacity);
            }
            if (this.initialContents.size() > this.capacity) {
                throw new IllegalStateException("The number of elements in the initial contents of the queue to be created exceeds its capacity.");
            }
            LinkedBlockingQueue queue = new LinkedBlockingQueue(this.capacity);
            queue.addAll(this.initialContents);
            return queue;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DelayQueueFactoryL<T extends Delayed>
    extends QueueFactory.AbstractQueueFactory<T>
    implements BlockingQueueFactory<T> {
        @Override
        public DelayQueue<T> createQueue() {
            if (this.initialContents == null || this.initialContents.isEmpty()) {
                return new DelayQueue();
            }
            return new DelayQueue(this.initialContents);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayBlockingQueueFactory<T>
    extends QueueFactory.AbstractQueueFactory<T>
    implements BlockingQueueFactory<T> {
        private int capacity = Integer.MAX_VALUE;
        private boolean fair = false;

        @Override
        public ArrayBlockingQueue<T> createQueue() {
            if (this.initialContents == null || this.initialContents.isEmpty()) {
                return new ArrayBlockingQueue(this.capacity, this.fair);
            }
            if (this.initialContents.size() > this.capacity) {
                throw new IllegalStateException("The number of elements in the initial contents of the queue to be created exceeds its capacity.");
            }
            ArrayBlockingQueue queue = new ArrayBlockingQueue(this.capacity, this.fair);
            queue.addAll(this.initialContents);
            return queue;
        }

        public void setCapacity(int capacity) {
            this.capacity = capacity;
        }

        public int getCapacity() {
            return this.capacity;
        }

        public boolean isFair() {
            return this.fair;
        }

        public void setFair(boolean fair) {
            this.fair = fair;
        }
    }
}

