/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.testFramework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.pipeline.Feeder;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageEventListener;
import org.apache.commons.pipeline.testFramework.TestFeeder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestStageContext
implements StageContext {
    public List<StageEventListener> listeners = Collections.synchronizedList(new ArrayList());
    public List<EventObject> raisedEvents = new ArrayList<EventObject>();
    public Map<String, TestFeeder> branchFeeders = new HashMap<String, TestFeeder>();
    public Map<Stage, Feeder> downstreamFeeders = new HashMap<Stage, Feeder>();
    public Map<String, Object> env = new HashMap<String, Object>();

    @Override
    public void registerListener(StageEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void raise(EventObject ev) {
        this.raisedEvents.add(ev);
        this.notifyListeners(ev);
    }

    private void notifyListeners(EventObject event) {
        for (StageEventListener listener : this.listeners) {
            listener.notify(event);
        }
    }

    @Override
    public Feeder getBranchFeeder(String key) {
        if (this.branchFeeders.containsKey(key)) {
            return this.branchFeeders.get(key);
        }
        TestFeeder feeder = new TestFeeder();
        this.branchFeeders.put(key, feeder);
        return feeder;
    }

    @Override
    public Feeder getDownstreamFeeder(Stage stage) {
        if (this.downstreamFeeders.containsKey(stage)) {
            return this.downstreamFeeders.get(stage);
        }
        TestFeeder feeder = new TestFeeder();
        this.downstreamFeeders.put(stage, feeder);
        return feeder;
    }

    public void registerDownstreamFeeder(Stage stage, Feeder feeder) {
        this.downstreamFeeders.put(stage, feeder);
    }

    @Override
    public Collection<StageEventListener> getRegisteredListeners() {
        return this.listeners;
    }

    @Override
    public Object getEnv(String key) {
        return this.env.get(key);
    }
}

