/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.testFramework;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.validation.ConsumedTypes;
import org.apache.commons.pipeline.validation.ProducesConsumed;

@ConsumedTypes(value={Object.class})
@ProducesConsumed
public class TestStage
implements Stage {
    private Log log = LogFactory.getLog(TestStage.class);
    private int index;
    private StageContext context;
    public List<Object> processedObjects = Collections.synchronizedList(new ArrayList());
    public boolean initialized = false;
    public boolean preprocessed = false;
    public boolean postprocessed = false;
    public boolean released = false;

    public TestStage(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void init(StageContext context) {
        this.context = context;
        this.initialized = true;
    }

    public void preprocess() throws StageException {
        this.preprocessed = true;
    }

    public void process(Object obj) throws StageException {
        this.log.info((Object)(this + " is processing object " + obj));
        this.processedObjects.add(obj);
        this.context.getDownstreamFeeder(this).feed(obj);
    }

    public void postprocess() throws StageException {
        this.postprocessed = true;
    }

    public void release() {
        this.released = true;
    }

    public String toString() {
        return "TEST STAGE (" + this.index + ")";
    }
}

