/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;

public class URLToInputStreamStage
extends BaseStage {
    private final Log log = LogFactory.getLog(URLToInputStreamStage.class);
    private List<InputStream> inputStreams = new ArrayList<InputStream>();

    public void process(Object obj) throws StageException {
        URL url = null;
        if (obj instanceof URL) {
            url = (URL)obj;
        } else if (obj instanceof String) {
            String urlString = (String)obj;
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException e) {
                throw new StageException(this, "Error converting url String:" + urlString, e);
            }
        }
        try {
            InputStream inputStream = url.openStream();
            this.inputStreams.add(inputStream);
            this.log.info((Object)"enqueing input stream");
            this.emit(inputStream);
        }
        catch (IOException e) {
            throw new StageException(this, "Error with stream from url:" + url, e);
        }
    }

    public void release() {
        this.log.info((Object)("running post process number of streams:" + this.inputStreams.size()));
        while (this.inputStreams.size() > 0) {
            InputStream is = this.inputStreams.remove(0);
            try {
                is.close();
                this.log.info((Object)"closed stream");
            }
            catch (IOException e) {
                this.log.warn((Object)"Error closing stream", (Throwable)e);
            }
        }
    }
}

