/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.util.EventObject;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageEventListener;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.event.KeyAvailableEvent;
import org.apache.commons.pipeline.stage.BaseStage;
import org.apache.commons.pipeline.util.KeyFactory;
import org.apache.commons.pipeline.util.QueueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyWaitBufferStage
extends BaseStage
implements StageEventListener {
    private Set<Object> receivedKeys = new TreeSet<Object>();
    private Map<Object, Queue<Object>> buffers = new TreeMap<Object, Queue<Object>>();
    private KeyFactory<Object, ? extends Object> keyFactory;
    private QueueFactory<Object> queueFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(EventObject ev) {
        if (ev instanceof KeyAvailableEvent) {
            KeyAvailableEvent e = (KeyAvailableEvent)ev;
            Set<Object> set = this.receivedKeys;
            synchronized (set) {
                this.receivedKeys.add(e.getKey());
            }
            if (this.buffers.containsKey(e.getKey())) {
                for (Object e2 : this.buffers.remove(e.getKey())) {
                    this.emit(e2);
                }
            }
        }
    }

    @Override
    public void init(StageContext context) {
        super.init(context);
        context.registerListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Object obj) throws StageException {
        Object key = this.keyFactory.generateKey(obj);
        Set<Object> set = this.receivedKeys;
        synchronized (set) {
            if (!this.receivedKeys.contains(key)) {
                if (!this.buffers.containsKey(key)) {
                    this.buffers.put(key, this.queueFactory.createQueue());
                }
                this.buffers.get(key).add(obj);
                return;
            }
        }
        this.emit(obj);
    }

    public KeyFactory<Object, ? extends Object> getKeyFactory() {
        return this.keyFactory;
    }

    public void setKeyFactory(KeyFactory<Object, ? extends Object> keyFactory) {
        this.keyFactory = keyFactory;
    }

    public QueueFactory<Object> getQueueFactory() {
        return this.queueFactory;
    }

    public void setQueueFactory(QueueFactory<Object> queueFactory) {
        this.queueFactory = queueFactory;
    }
}

