/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;

public class InvokeStaticMethodStage
extends BaseStage {
    private String nullResultBranchKey;
    private Method method;

    public InvokeStaticMethodStage(Method method) {
        this.method = method;
    }

    public InvokeStaticMethodStage(String className, String methodName, String ... argumentTypeNames) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = InvokeStaticMethodStage.class.getClassLoader().loadClass(className);
        Class[] argTypes = new Class[argumentTypeNames.length];
        for (int i = 0; i < argumentTypeNames.length; ++i) {
            argTypes[i] = Class.forName(argumentTypeNames[i]);
        }
        this.method = clazz.getMethod(methodName, argTypes);
    }

    public Method getMethod() {
        return this.method;
    }

    public void process(Object obj) throws StageException {
        try {
            Object result = this.method.invoke(null, obj);
            if (result != null) {
                this.emit(result);
            } else if (this.nullResultBranchKey != null) {
                this.context.getBranchFeeder(this.nullResultBranchKey).feed(obj);
            }
        }
        catch (IllegalAccessException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
    }

    public String getNullResultBranchKey() {
        return this.nullResultBranchKey;
    }

    public void setNullResultBranchKey(String nullResultBranchKey) {
        this.nullResultBranchKey = nullResultBranchKey;
    }
}

