/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;

public class InvokeMethodStage
extends BaseStage {
    private Method method;
    private Object[] arguments;

    public InvokeMethodStage(Method method) {
        this.method = method;
        this.arguments = new Object[0];
    }

    public InvokeMethodStage(Method method, Object ... arguments) {
        this.method = method;
        this.arguments = arguments;
    }

    public InvokeMethodStage(String className, String methodName, Object ... arguments) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clazz = InvokeMethodStage.class.getClassLoader().loadClass(className);
        Class[] argTypes = new Class[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            argTypes[i] = arguments[i].getClass();
        }
        this.method = clazz.getMethod(methodName, argTypes);
        this.arguments = arguments;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void process(Object obj) throws StageException {
        try {
            Object result = this.method.invoke(obj, this.arguments);
            this.emit(result);
        }
        catch (IllegalAccessException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
    }
}

