/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;

public class InputStreamLineBreakStage
extends BaseStage {
    private boolean ignoringBlankLines = false;

    public InputStreamLineBreakStage() {
    }

    public InputStreamLineBreakStage(boolean ignoringBlankLines) {
        this.ignoringBlankLines = ignoringBlankLines;
    }

    public void process(Object obj) throws StageException {
        InputStream is = (InputStream)obj;
        try {
            InputStreamReader reader = new InputStreamReader(is);
            BufferedReader buffered = new BufferedReader(reader);
            String line = buffered.readLine();
            while (line != null) {
                if (!this.ignoringBlankLines || !line.trim().equals("")) {
                    this.emit(line);
                }
                line = buffered.readLine();
            }
        }
        catch (IOException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
    }

    public boolean isIgnoringBlankLines() {
        return this.ignoringBlankLines;
    }

    public void setIgnoringBlankLines(boolean ignoringBlankLines) {
        this.ignoringBlankLines = ignoringBlankLines;
    }
}

