/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;
import org.apache.commons.pipeline.validation.ConsumedTypes;
import org.apache.commons.pipeline.validation.ProducedTypes;

@ConsumedTypes(value={URL.class, String.class})
@ProducedTypes(value={File.class})
public class HttpFileDownloadStage
extends BaseStage {
    private static final int BUFFER_SIZE = 10000;
    private String workDir = null;
    private Log log = LogFactory.getLog(HttpFileDownloadStage.class);

    public HttpFileDownloadStage() {
    }

    public HttpFileDownloadStage(String workDir) {
        this.workDir = workDir;
    }

    public void process(Object obj) throws StageException {
        URL url;
        block10: {
            try {
                if (obj instanceof String) {
                    url = new URL((String)obj);
                    break block10;
                }
                if (obj instanceof URL) {
                    url = (URL)obj;
                    break block10;
                }
                throw new IllegalArgumentException("Unrecognized parameter class to process() for HttpFileDownload: " + obj.getClass().getName() + "; must be URL or String");
            }
            catch (MalformedURLException e) {
                throw new StageException(this, "Malformed URL: " + obj, e);
            }
        }
        this.log.debug((Object)("Retrieving data from " + url.toString()));
        HttpURLConnection con = null;
        try {
            con = (HttpURLConnection)url.openConnection();
            File workDir = this.workDir == null ? null : new File(this.workDir);
            File workFile = File.createTempFile("http-file-download", "tmp", workDir);
            BufferedInputStream in = new BufferedInputStream(con.getInputStream());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(workFile, false));
            byte[] buffer = new byte[10000];
            int results = 0;
            while ((results = ((InputStream)in).read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, results);
            }
            ((OutputStream)out).close();
            ((InputStream)in).close();
            this.emit(workFile);
        }
        catch (IOException e) {
            throw new StageException(this, "An error occurred downloading a data file from " + url.toString(), e);
        }
        finally {
            con.disconnect();
        }
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public URL handleRedirects(URL url) throws IOException, MalformedURLException {
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        int response = con.getResponseCode();
        this.log.debug((Object)("Response code for " + url + " = " + response));
        if (response == 301 || response == 302) {
            String location = con.getHeaderField("Location");
            this.log.debug((Object)("Handling redirect to location: " + location));
            url = location.startsWith("http:") ? new URL(location) : (location.startsWith("/") ? new URL("http://" + url.getHost() + location) : new URL(con.getURL(), location));
            url = this.handleRedirects(url);
        }
        return url;
    }
}

