/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;

public class FtpFileDownloadStage
extends BaseStage {
    private final Log log = LogFactory.getLog(FtpFileDownloadStage.class);
    private String workDir = "/tmp";
    private File fworkDir;
    private FTPClient client = new FTPClient();
    private String host;
    private String user;
    private String password;
    private int port;

    public FtpFileDownloadStage() {
    }

    public FtpFileDownloadStage(String workDir) {
        this.workDir = workDir;
    }

    public void preprocess() throws StageException {
        super.preprocess();
        if (this.fworkDir == null) {
            this.fworkDir = new File(this.workDir);
        }
        if (!this.fworkDir.exists()) {
            this.fworkDir.mkdirs();
        }
        try {
            this.client.connect(this.host, this.port);
            this.log.debug((Object)this.client.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
                throw new IOException("FTP server at host " + this.host + " refused connection.");
            }
            this.client.login(this.user, this.password);
            this.log.debug((Object)this.client.getReplyString());
            if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
                throw new StageException((Stage)this, "FTP login failed for user " + this.user + ": " + this.client.getReplyString());
            }
        }
        catch (IOException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
    }

    public void process(Object obj) throws StageException {
        if (!this.fworkDir.exists()) {
            throw new StageException((Stage)this, "The work directory for file download " + this.workDir.toString() + " does not exist.");
        }
        FileSpec spec = (FileSpec)obj;
        try {
            this.client.setFileType(spec.type.intValue());
            this.client.changeWorkingDirectory(spec.path);
            if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
                throw new IOException("FTP client could not change to remote directory " + spec.path + ": " + this.client.getReplyString());
            }
            this.log.debug((Object)("FTP connection successfully established to " + this.host + ":" + spec.path));
            this.client.enterLocalPassiveMode();
            this.searchCurrentDirectory("", spec);
        }
        catch (IOException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchCurrentDirectory(String path, FileSpec spec) throws IOException {
        FTPFile[] files = this.client.listFiles();
        if (!FTPReply.isPositiveCompletion((int)this.client.getReplyCode())) {
            throw new IOException("FTP client could not obtain file list : " + this.client.getReplyString());
        }
        block3: for (FTPFile file : files) {
            String localPath = path + File.separatorChar + file.getName();
            if (file.isDirectory() && spec.recursive) {
                this.log.debug((Object)("Recursing into directory " + file.getName()));
                this.client.changeWorkingDirectory(file.getName());
                this.searchCurrentDirectory(localPath, spec);
                this.client.changeToParentDirectory();
                continue;
            }
            this.log.debug((Object)("Examining file " + localPath));
            for (Criterion crit : spec.criteria) {
                if (crit.matches(file)) continue;
                this.log.info((Object)("File " + localPath + " failed criterion check " + crit));
                continue block3;
            }
            boolean getFile = true;
            File localFile = new File(this.workDir + File.separatorChar + localPath);
            if (localFile.exists()) {
                if (spec.overwrite) {
                    this.log.info((Object)("Replacing existing local file " + localFile.getPath()));
                    getFile = true;
                } else {
                    if (spec.ignoreExisting) {
                        this.log.info((Object)("Ignoring existing local file " + localFile.getPath()));
                        continue;
                    }
                    this.log.info((Object)("Using existing local file " + localFile.getPath()));
                    getFile = false;
                }
            } else {
                getFile = true;
            }
            if (getFile) {
                if (!localFile.getParentFile().exists()) {
                    localFile.getParentFile().mkdir();
                }
                FileOutputStream out = new FileOutputStream(localFile);
                try {
                    this.client.retrieveFile(file.getName(), (OutputStream)out);
                }
                finally {
                    out.flush();
                    ((OutputStream)out).close();
                }
            }
            this.emit(localFile);
        }
    }

    public void release() {
        try {
            this.client.disconnect();
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void setWorkDir(String workDir) {
        this.workDir = workDir;
    }

    public String getWorkDir() {
        return this.workDir;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public static class FileDateMatchCriterion
    implements Criterion {
        private Date startDate;
        private Date endDate;

        public FileDateMatchCriterion(Date startDate, Date endDate) {
            this.startDate = startDate;
            this.endDate = endDate;
        }

        public boolean matches(FTPFile file) {
            Calendar cal = file.getTimestamp();
            return (this.startDate == null || !cal.getTime().before(this.startDate)) && (this.endDate == null || !cal.getTime().after(this.endDate));
        }

        public String toString() {
            return "file date is between " + this.startDate + " and " + this.endDate;
        }
    }

    public static class FileNameMatchCriterion
    implements Criterion {
        private Pattern pattern;
        private String _pattern;

        public FileNameMatchCriterion(String pattern) {
            this._pattern = pattern;
            this.pattern = Pattern.compile(pattern);
        }

        public boolean matches(FTPFile file) {
            return this.pattern.matcher(file.getName()).matches();
        }

        public String toString() {
            return "filename matches pattern " + this._pattern;
        }
    }

    public static interface Criterion {
        public boolean matches(FTPFile var1);
    }

    public static class FileSpec {
        private String path = "/";
        private boolean recursive;
        private boolean overwrite = false;
        private boolean ignoreExisting = false;
        private FileType type = FileType.BINARY;
        private Set<Criterion> criteria = new HashSet<Criterion>();

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getPattern() {
            return null;
        }

        public void setPattern(String pattern) {
            this.criteria.add(new FileNameMatchCriterion(pattern));
        }

        public void addCriterion(Criterion crit) {
            this.criteria.add(crit);
        }

        public void setRecursive(boolean recursive) {
            this.recursive = recursive;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public void setFileType(String fileType) {
            this.type = "ascii".equalsIgnoreCase(fileType) ? FileType.ASCII : FileType.BINARY;
        }

        public String getFileType() {
            return this.type.toString();
        }

        public boolean isOverwrite() {
            return this.overwrite;
        }

        public void setOverwrite(boolean overwrite) {
            this.overwrite = overwrite;
        }

        public boolean isIgnoreExisting() {
            return this.ignoreExisting;
        }

        public void setIgnoreExisting(boolean ignoreExisting) {
            this.ignoreExisting = ignoreExisting;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum FileType {
            ASCII(0),
            BINARY(2);

            private int type;

            private FileType(int type) {
                this.type = type;
            }

            public int intValue() {
                return this.type;
            }
        }
    }
}

