/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.io.File;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;
import org.apache.commons.pipeline.validation.ConsumedTypes;
import org.apache.commons.pipeline.validation.ProducedTypes;

@ConsumedTypes(value={String.class, File.class})
@ProducedTypes(value={File.class})
public class FileFinderStage
extends BaseStage {
    private final Log log = LogFactory.getLog(FileFinderStage.class);
    private String filePattern = ".*";
    Pattern pattern;

    public void preprocess() throws StageException {
        super.preprocess();
        this.pattern = Pattern.compile(this.filePattern);
    }

    public void process(Object obj) {
        File file = obj instanceof String ? new File((String)obj) : (File)obj;
        this.log.debug((Object)("Examining file " + file.getAbsolutePath()));
        if (!file.exists()) {
            this.log.info((Object)("File " + file + " does not exist."));
        } else if (file.isDirectory()) {
            File[] files = file.listFiles();
            this.log.debug((Object)(file.getName() + " is a directory, processing " + files.length + " files within."));
            for (int i = 0; i < files.length; ++i) {
                this.process(files[i]);
            }
        } else if (this.pattern.matcher(file.getName()).matches()) {
            this.emit(file);
        }
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String pattern) {
        this.filePattern = pattern;
    }
}

