/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.lang.management.ManagementFactory;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;
import org.apache.commons.pipeline.Feeder;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.ExtendedBaseStageMBean;

public abstract class ExtendedBaseStage
implements Stage,
ExtendedBaseStageMBean {
    private static final float BRANCH_BLOCK_THRESHOLD = 1.0f;
    private static final int DEFAULT_DESCRIPTIVE_STATS_WINDOW_SIZE = 100;
    private static final String DEFAULT_QUEUE_NAME = "[DefaultQueue]";
    private static final int DEFAULT_STATUS_INTERVAL = 1000;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected StageContext stageContext;
    private Feeder downstreamFeeder;
    private String stageName;
    private final AtomicLong objectsReceived = new AtomicLong(0L);
    private final AtomicLong unhandledExceptions = new AtomicLong(0L);
    private final AtomicLong totalServiceTime = new AtomicLong(0L);
    private final AtomicLong totalEmitTime = new AtomicLong(0L);
    private final AtomicLong totalEmits = new AtomicLong(0L);
    private final Map<String, AtomicLong> emitTimeByBranch = new HashMap<String, AtomicLong>();
    private int currentStatWindowSize = 100;
    private SynchronizedDescriptiveStatistics serviceTimeStatistics;
    private long statusInterval = 1000L;
    private Integer statusBatchSize = 1;
    private boolean collectBranchStats = false;
    private boolean preProcessed = false;
    private boolean postProcessed = false;
    private boolean jmxEnabled = true;
    private final String className = this.getClass().getSimpleName();
    protected static ThreadLocal<AtomicLong> emitTotal = new ThreadLocal<AtomicLong>(){

        @Override
        protected synchronized AtomicLong initialValue() {
            return new AtomicLong();
        }
    };
    protected static ThreadLocal<Map<String, AtomicLong>> threadLocalEmitBranchTime = new ThreadLocal<Map<String, AtomicLong>>(){

        @Override
        protected synchronized Map<String, AtomicLong> initialValue() {
            return new HashMap<String, AtomicLong>();
        }
    };
    protected static ThreadLocal<AtomicInteger> emitCount = new ThreadLocal<AtomicInteger>(){

        @Override
        protected synchronized AtomicInteger initialValue() {
            return new AtomicInteger();
        }
    };
    protected static ThreadLocal<NumberFormat> floatFormatter = new ThreadLocal<NumberFormat>(){

        @Override
        protected synchronized NumberFormat initialValue() {
            return new DecimalFormat("##0.000");
        }
    };

    public void init(StageContext context) {
        this.stageContext = context;
        if (this.jmxEnabled) {
            this.enableJMX(context);
        }
    }

    private final void enableJMX(StageContext context) {
        block8: {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs != null) {
                StringBuilder sb = new StringBuilder("org.apache.commons.pipeline:");
                sb.append("class=").append(this.className);
                if (this.stageName != null) {
                    sb.append(",name=").append(this.stageName);
                }
                try {
                    ObjectName name = new ObjectName(sb.toString());
                    if (mbs.isRegistered(name)) {
                        this.log.info((Object)("JMX Overlap. Multiple instances of '" + name + "'. Only one will be registered."));
                        break block8;
                    }
                    Class mbeanInterface = ExtendedBaseStageMBean.class;
                    try {
                        Class<?>[] interfaces = this.getClass().getInterfaces();
                        for (int i = 0; i < interfaces.length; ++i) {
                            Class<?> current = interfaces[i];
                            if (current == ExtendedBaseStageMBean.class || !ExtendedBaseStageMBean.class.isAssignableFrom(current)) continue;
                            mbeanInterface = current;
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.log.info((Object)"Reflection error while checking for JMX interfaces.");
                        mbeanInterface = ExtendedBaseStageMBean.class;
                    }
                    StandardMBean mbean = new StandardMBean(this, mbeanInterface);
                    mbs.registerMBean(mbean, name);
                    this.log.info((Object)("JMX MBean registered: " + name.toString() + " (" + mbeanInterface.getSimpleName() + ")"));
                }
                catch (Exception e) {
                    this.log.warn((Object)"Failed to register with JMX server", (Throwable)e);
                }
            }
        }
    }

    public final void preprocess() throws StageException {
        if (!this.preProcessed) {
            this.serviceTimeStatistics = new SynchronizedDescriptiveStatistics();
            this.serviceTimeStatistics.setWindowSize(this.currentStatWindowSize);
            this.innerPreprocess();
        }
        this.preProcessed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(Object obj) throws StageException {
        this.objectsReceived.incrementAndGet();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.innerProcess(obj);
        }
        catch (Exception e) {
            this.log.error((Object)("Uncaught exception in " + this.className + ": " + e.getMessage()), (Throwable)e);
            this.unhandledExceptions.incrementAndGet();
        }
        stopWatch.stop();
        long totalTime = stopWatch.getTime();
        this.totalServiceTime.addAndGet(totalTime);
        this.serviceTimeStatistics.addValue((double)totalTime);
        this.totalEmits.addAndGet(emitCount.get().intValue());
        this.totalEmitTime.addAndGet(emitTotal.get().longValue());
        emitCount.remove();
        emitTotal.remove();
        if (this.collectBranchStats) {
            for (Map.Entry<String, AtomicLong> entry : threadLocalEmitBranchTime.get().entrySet()) {
                if (this.emitTimeByBranch.containsKey(entry.getKey())) {
                    this.emitTimeByBranch.get(entry.getKey()).addAndGet(entry.getValue().longValue());
                    continue;
                }
                Map<String, AtomicLong> map = this.emitTimeByBranch;
                synchronized (map) {
                    if (this.emitTimeByBranch.containsKey(entry.getKey())) {
                        this.emitTimeByBranch.get(entry.getKey()).addAndGet(entry.getValue().longValue());
                    } else {
                        this.emitTimeByBranch.put(entry.getKey(), new AtomicLong(entry.getValue().longValue()));
                    }
                }
            }
            threadLocalEmitBranchTime.remove();
        }
        if (this.objectsReceived.longValue() % this.statusInterval == 0L) {
            this.logStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void emit(Object obj) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getClass() + " is emitting object " + obj));
        }
        if (this.downstreamFeeder == null) {
            ExtendedBaseStage extendedBaseStage = this;
            synchronized (extendedBaseStage) {
                this.downstreamFeeder = this.stageContext.getDownstreamFeeder(this);
            }
        }
        this.feed(DEFAULT_QUEUE_NAME, this.downstreamFeeder, obj);
    }

    public final void emit(String branch, Object obj) {
        Feeder feeder = this.stageContext.getBranchFeeder(branch);
        this.feed(branch, feeder, obj);
    }

    private void feed(String name, Feeder feeder, Object obj) {
        if (feeder == null) {
            String objectType = obj != null ? obj.getClass().getSimpleName() : "null";
            this.log.error((Object)("Ignoring attempt to emit " + objectType + " object to invalid feeder"));
            return;
        }
        StopWatch emitWatch = new StopWatch();
        emitWatch.start();
        feeder.feed(obj);
        emitWatch.stop();
        emitTotal.get().addAndGet(emitWatch.getTime());
        emitCount.get().incrementAndGet();
        if (this.collectBranchStats) {
            if (!threadLocalEmitBranchTime.get().containsKey(name)) {
                AtomicLong currentTotal = new AtomicLong(emitWatch.getTime());
                threadLocalEmitBranchTime.get().put(name, currentTotal);
            } else {
                threadLocalEmitBranchTime.get().get(name).addAndGet(emitWatch.getTime());
            }
        }
    }

    public final void postprocess() throws StageException {
        if (!this.postProcessed) {
            this.logStatus();
            this.innerPostprocess();
        }
        this.postProcessed = true;
    }

    public void release() {
    }

    public abstract void innerProcess(Object var1) throws StageException;

    public void innerPreprocess() throws StageException {
    }

    public void innerPostprocess() throws StageException {
    }

    public abstract String status();

    public void logStatus() {
        String logMessage = this.getStatusMessage();
        this.log.info((Object)logMessage);
    }

    public String getStatusMessage() {
        String stageSpecificStatus;
        long count;
        StringBuilder sb = new StringBuilder(512);
        NumberFormat formatter = floatFormatter.get();
        float serviceTime = this.totalServiceTime.floatValue() / 1000.0f;
        float emitTime = this.totalEmitTime.floatValue() / 1000.0f;
        float netServiceTime = serviceTime - emitTime;
        float emitPercentage = 0.0f;
        float emitFloat = this.totalEmits.floatValue();
        float recvFloat = this.objectsReceived.floatValue();
        if (recvFloat > 0.0f) {
            emitPercentage = emitFloat / recvFloat * 100.0f;
        }
        sb.append("\n\t === ").append(this.className).append(" Generic Stats === ");
        if (this.statusBatchSize > 1) {
            sb.append("\n\tStatus Batch Size (all /obj and /sec include this): ").append(this.statusBatchSize);
        }
        sb.append("\n\tTotal objects received:").append(this.objectsReceived);
        sb.append("\n\tTotal unhandled exceptions:").append(this.unhandledExceptions);
        sb.append("\n\tTotal objects emitted:").append(this.totalEmits);
        if (emitFloat > 0.0f) {
            sb.append(" (").append(formatter.format(emitPercentage)).append("%)");
        }
        sb.append("\n\tTotal gross processing time (sec):").append(formatter.format(serviceTime));
        sb.append("\n\tTotal emit blocked time (sec):").append(formatter.format(emitTime));
        sb.append("\n\tTotal net processing time (sec):").append(formatter.format(netServiceTime));
        float avgServiceTime = 0.0f;
        float avgEmitTime = 0.0f;
        float avgNetServiceTime = 0.0f;
        if (this.objectsReceived.longValue() > 0L) {
            avgServiceTime = serviceTime / this.objectsReceived.floatValue() / (float)this.statusBatchSize.intValue();
            avgEmitTime = emitTime / this.objectsReceived.floatValue() / (float)this.statusBatchSize.intValue();
            avgNetServiceTime = netServiceTime / this.objectsReceived.floatValue() / (float)this.statusBatchSize.intValue();
        }
        sb.append("\n\tAverage gross processing time (sec/obj):").append(formatter.format(avgServiceTime));
        sb.append("\n\tAverage emit blocked time (sec/obj):").append(formatter.format(avgEmitTime));
        sb.append("\n\tAverage net processing time (sec/obj):").append(formatter.format(avgNetServiceTime));
        if (this.serviceTimeStatistics != null && (count = this.serviceTimeStatistics.getN()) > 0L) {
            double avgMillis = this.getCurrentServiceTimeAverage() / (double)this.statusBatchSize.intValue();
            sb.append("\n\tAverage gross processing time in last ").append(count).append(" (sec/obj):").append(formatter.format(avgMillis / 1000.0));
        }
        float grossThroughput = 0.0f;
        if (avgServiceTime > 0.0f) {
            grossThroughput = 1.0f / avgServiceTime;
        }
        float netThroughput = 0.0f;
        if (avgNetServiceTime > 0.0f) {
            netThroughput = 1.0f / avgNetServiceTime;
        }
        sb.append("\n\tGross throughput (obj/sec):").append(formatter.format(grossThroughput));
        sb.append("\n\tNet throughput (obj/sec):").append(formatter.format(netThroughput));
        float percWorking = 0.0f;
        float percBlocking = 0.0f;
        if (serviceTime > 0.0f) {
            percWorking = netServiceTime / serviceTime * 100.0f;
            percBlocking = emitTime / serviceTime * 100.0f;
        }
        sb.append("\n\t% time working:").append(formatter.format(percWorking));
        sb.append("\n\t% time blocking:").append(formatter.format(percBlocking));
        if (this.collectBranchStats && this.emitTimeByBranch.size() > 1 && percBlocking >= 1.0f) {
            try {
                for (Map.Entry<String, AtomicLong> entry : this.emitTimeByBranch.entrySet()) {
                    float branchBlockSec = entry.getValue().floatValue() / 1000.0f;
                    float branchBlockPerc = branchBlockSec / emitTime * 100.0f;
                    sb.append("\n\t\t% branch ").append(entry.getKey()).append(":").append(formatter.format(branchBlockPerc));
                }
            }
            catch (RuntimeException e) {
                sb.append("\n\t\tproblem getting per-branch stats: ").append(e.getMessage());
            }
        }
        if ((stageSpecificStatus = this.status()) != null && stageSpecificStatus.length() > 0) {
            sb.append("\n\t === ").append(this.className).append(" Specific Stats === ");
            sb.append(stageSpecificStatus);
        }
        return sb.toString();
    }

    protected String formatTotalTimeStat(String name, AtomicLong totalTime) {
        return this.formatTotalTimeStat(name, totalTime.longValue());
    }

    protected String formatTotalTimeStat(String name, long totalTime) {
        if (name == null || totalTime < 0L) {
            return "";
        }
        NumberFormat formatter = floatFormatter.get();
        StringBuilder sb = new StringBuilder();
        float totalSec = (float)totalTime / 1000.0f;
        float average = 0.0f;
        if (this.getObjectsReceived() > 0L) {
            average = totalSec / (float)this.getObjectsReceived() / (float)this.statusBatchSize.intValue();
        }
        if (this.log.isDebugEnabled()) {
            sb.append("\n\tTotal ").append(name).append(" processing time (sec):").append(formatter.format(totalSec));
        }
        sb.append("\n\tAverage ").append(name).append(" processing time (sec/obj):").append(formatter.format(average));
        if (this.log.isDebugEnabled() && average > 0.0f) {
            float throughput = 1.0f / average * (float)this.statusBatchSize.intValue();
            sb.append("\n\tThroughput for ").append(name).append(" (obj/sec):").append(formatter.format(throughput));
        }
        return sb.toString();
    }

    protected String formatCounterStat(String name, AtomicInteger count) {
        return this.formatCounterStat(name, count.get());
    }

    protected String formatCounterStat(String name, AtomicLong count) {
        return this.formatCounterStat(name, count.get());
    }

    protected String formatCounterStat(String name, long count) {
        if (name == null || count < 0L || this.getObjectsReceived() <= 0L) {
            return "";
        }
        NumberFormat formatter = floatFormatter.get();
        StringBuilder sb = new StringBuilder();
        float perc = (float)count * (float)this.statusBatchSize.intValue() / (float)this.getObjectsReceived() * 100.0f;
        sb.append("\n\tNumber of ").append(name).append(" (").append(formatter.format(perc)).append("%) :").append(count);
        return sb.toString();
    }

    public Long getStatusInterval() {
        return this.statusInterval;
    }

    public void setStatusInterval(Long statusInterval) {
        this.statusInterval = statusInterval;
    }

    public Integer getStatusBatchSize() {
        return this.statusBatchSize;
    }

    public void setStatusBatchSize(Integer statusBatchSize) {
        this.statusBatchSize = statusBatchSize;
    }

    public long getObjectsReceived() {
        return this.objectsReceived.longValue();
    }

    public long getTotalServiceTime() {
        return this.totalServiceTime.longValue();
    }

    public long getTotalEmitTime() {
        return this.totalEmitTime.longValue();
    }

    public long getTotalEmits() {
        return this.totalEmits.longValue();
    }

    public Boolean getCollectBranchStats() {
        return this.collectBranchStats;
    }

    public void setCollectBranchStats(Boolean collectBranchStats) {
        this.collectBranchStats = collectBranchStats;
    }

    public Integer getCurrentStatWindowSize() {
        return this.currentStatWindowSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentStatWindowSize(Integer newStatWindowSize) {
        if (this.serviceTimeStatistics != null && newStatWindowSize != this.currentStatWindowSize) {
            SynchronizedDescriptiveStatistics synchronizedDescriptiveStatistics = this.serviceTimeStatistics;
            synchronized (synchronizedDescriptiveStatistics) {
                this.serviceTimeStatistics.setWindowSize(newStatWindowSize.intValue());
            }
        }
        this.currentStatWindowSize = newStatWindowSize;
    }

    public String getStageName() {
        return this.stageName;
    }

    public void setStageName(String name) {
        this.stageName = name;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public double getCurrentServiceTimeAverage() {
        double avg = -1.0;
        avg = this.serviceTimeStatistics.getMean();
        return avg;
    }
}

