/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.stage.BaseStage;

public class DynamicLookupStaticMethodStage
extends BaseStage {
    private String nullResultBranchKey;
    private String methodName;
    private Class clazz;

    public DynamicLookupStaticMethodStage(Class clazz, String methodName) {
        if (clazz == null) {
            throw new IllegalArgumentException("Argument 'clazz' can not be null.");
        }
        if (methodName == null) {
            throw new IllegalArgumentException("Argument 'methodName' can not be null.");
        }
        this.clazz = clazz;
        this.methodName = methodName;
    }

    public DynamicLookupStaticMethodStage(String className, String methodName) throws ClassNotFoundException {
        this(Thread.currentThread().getContextClassLoader().loadClass(className), methodName);
    }

    public void process(Object obj) throws StageException {
        Class[] argTypes;
        if (obj.getClass().isArray()) {
            Object[] objs = (Object[])obj;
            argTypes = new Class[objs.length];
            for (int i = 0; i < objs.length; ++i) {
                argTypes[i] = objs[i].getClass();
            }
        } else {
            argTypes = new Class[]{obj.getClass()};
        }
        try {
            Object result;
            Method method = this.clazz.getMethod(this.methodName, argTypes);
            Object object = result = obj.getClass().isArray() ? method.invoke(null, (Object[])obj) : method.invoke(null, obj);
            if (result != null) {
                this.emit(result);
            } else if (this.nullResultBranchKey != null) {
                this.context.getBranchFeeder(this.nullResultBranchKey).feed(obj);
            }
        }
        catch (NoSuchMethodException e) {
            StringBuilder message = new StringBuilder("No acceptable method " + this.methodName + " found with argument(s) of type: [ ");
            for (Class clazz : argTypes) {
                message.append(clazz.getName()).append(" ");
            }
            message.append("]");
            throw new StageException(this, message.toString(), e);
        }
        catch (IllegalAccessException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new StageException((Stage)this, (Throwable)e);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Class getMethodClass() {
        return this.clazz;
    }

    public String getNullResultBranchKey() {
        return this.nullResultBranchKey;
    }

    public void setNullResultBranchKey(String nullResultBranchKey) {
        this.nullResultBranchKey = nullResultBranchKey;
    }
}

