/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pipeline.stage;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.pipeline.Feeder;
import org.apache.commons.pipeline.Stage;
import org.apache.commons.pipeline.StageContext;
import org.apache.commons.pipeline.StageException;
import org.apache.commons.pipeline.validation.ConsumedTypes;
import org.apache.commons.pipeline.validation.ProducesConsumed;

@ConsumedTypes(value={Object.class})
@ProducesConsumed
public abstract class BaseStage
implements Stage {
    private Log log = LogFactory.getLog(BaseStage.class);
    protected StageContext context;
    private Feeder downstreamFeeder;

    public void init(StageContext context) {
        this.context = context;
    }

    public void preprocess() throws StageException {
    }

    public void process(Object obj) throws StageException {
        this.emit(obj);
    }

    public void postprocess() throws StageException {
    }

    public void release() {
    }

    public final void emit(Object obj) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getClass() + " is emitting object " + obj));
        }
        if (this.downstreamFeeder == null) {
            this.downstreamFeeder = this.context.getDownstreamFeeder(this);
        }
        this.downstreamFeeder.feed(obj);
    }

    public final void emit(String branch, Object obj) {
        this.context.getBranchFeeder(branch).feed(obj);
    }
}

